/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.people.impl;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.DependentInitialisation;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.ListType;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.IMap;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.people.ICaptain;
import ch.sahits.game.openpatrician.model.people.PeopleFactory;
import ch.sahits.game.openpatrician.model.people.impl.CaptainTownMapping;
import ch.sahits.game.openpatrician.util.StartNewGameBean;
import com.google.common.collect.Lists;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
@Lazy
@DependentInitialisation(value=StartNewGameBean.class)
@ClassCategory(value={EClassCategory.SERIALIZABLE_BEAN, EClassCategory.SINGLETON_BEAN})
public class CaptainsState {
    @Autowired
    @XStreamOmitField
    private Random rnd;
    @Value(value="${freeCaptain.max}")
    private int maxFreeCaptains;
    @Value(value="${freeCaptain.timeInTown}")
    private int maxTimeInTown;
    @Autowired
    @XStreamOmitField
    private PeopleFactory peopleFactory;
    private IMap map;
    @Autowired
    private Date date;
    @ListType(value=CaptainTownMapping.class)
    private List<CaptainTownMapping> captainMapping = Lists.newArrayList();

    public void init(IMap map) {
        this.map = map;
        for (int i = 0; i < this.maxFreeCaptains; ++i) {
            ICity city = this.getRandomCity();
            DateTime currentDate = this.date.getCurrentDate();
            double nextGaussian = this.rnd.nextDouble();
            DateTime arrival = currentDate.minus((long)((int)Math.rint(nextGaussian * (double)this.maxTimeInTown)));
            ICaptain captain = this.peopleFactory.createNewCaptainProperty();
            this.captainMapping.add(new CaptainTownMapping(city, arrival, captain));
        }
    }

    private ICity getRandomCity() {
        List<ICity> cities = this.map.getCities();
        return cities.get(this.rnd.nextInt(cities.size()));
    }

    public Optional<ICaptain> getCaptain(ICity city) {
        for (CaptainTownMapping mapped : this.captainMapping) {
            if (!mapped.getTown().equals(city)) continue;
            return Optional.of(mapped.getCaptain());
        }
        return Optional.empty();
    }

    public void hireCaptain(ICaptain captain, ICity city) {
        Iterator<CaptainTownMapping> iterator = this.captainMapping.iterator();
        while (iterator.hasNext()) {
            CaptainTownMapping mapped = iterator.next();
            if (!mapped.getTown().equals(city) || !mapped.getCaptain().equals(captain)) continue;
            iterator.remove();
            break;
        }
    }
}

