/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.people.impl;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.model.AIPlayerList;
import ch.sahits.game.openpatrician.model.IAIPlayer;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.IUpdateableState;
import ch.sahits.game.openpatrician.model.people.IConcurrent;
import ch.sahits.game.openpatrician.model.people.impl.BaseTavernPerson;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.util.List;
import java.util.Random;
import org.springframework.beans.factory.annotation.Autowired;

@Prototype
@ClassCategory(value={EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
public class ConcurrentState
extends BaseTavernPerson
implements IConcurrent,
IUpdateableState {
    @Autowired
    @XStreamOmitField
    private Random rnd;
    @Autowired
    private AIPlayerList aiPlayers;
    private IPlayer clientPlayer;
    private IPlayer concurrentPlayer;
    private int premium;

    @Override
    public String getName() {
        return this.clientPlayer.getName() + " " + this.clientPlayer.getLastName();
    }

    @Override
    public String getConcurrentName() {
        return this.concurrentPlayer.getName() + " " + this.concurrentPlayer.getLastName();
    }

    @Override
    public void update() {
        List<IAIPlayer> players = this.aiPlayers.getAll();
        int index = this.rnd.nextInt(players.size());
        IPlayer p1 = players.get(index);
        int other = this.rnd.nextInt(players.size());
        while (other == index) {
            other = this.rnd.nextInt(players.size());
        }
        IPlayer p2 = players.get(other);
        this.setClientPlayer(p1);
        this.setConcurrentPlayer(p2);
        this.setPremium(this.rnd.nextInt(8500) + 1500);
    }

    @Override
    public IPlayer getClientPlayer() {
        return this.clientPlayer;
    }

    public void setClientPlayer(IPlayer clientPlayer) {
        this.clientPlayer = clientPlayer;
    }

    @Override
    public IPlayer getConcurrentPlayer() {
        return this.concurrentPlayer;
    }

    public void setConcurrentPlayer(IPlayer concurrentPlayer) {
        this.concurrentPlayer = concurrentPlayer;
    }

    @Override
    public int getPremium() {
        return this.premium;
    }

    public void setPremium(int premium) {
        this.premium = premium;
    }
}

