/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.people.impl;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.model.IUpdateableState;
import ch.sahits.game.openpatrician.model.people.IContractBroker;
import ch.sahits.game.openpatrician.model.people.impl.BaseTradePerson;
import ch.sahits.game.openpatrician.model.product.AmountablePrice;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.util.RandomNameLoader;
import javax.annotation.PostConstruct;

@Prototype
@ClassCategory(value={EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
public class ContractBrookerState
extends BaseTradePerson
implements IContractBroker,
IUpdateableState {
    private String name;
    private final AmountablePrice<IWare> amountAndPrice;
    private final IWare ware;
    private int deliveredAmount = 0;
    private static RandomNameLoader firstNameLoader = new RandomNameLoader("firstnames.properties");
    private static RandomNameLoader lastNameLoader = new RandomNameLoader("lastnames.properties");

    public ContractBrookerState(AmountablePrice<IWare> amountAndPrice, IWare ware) {
        this.amountAndPrice = amountAndPrice;
        this.ware = ware;
    }

    @Override
    @PostConstruct
    public void update() {
        this.name = firstNameLoader.getRandomName() + " " + lastNameLoader.getRandomName();
    }

    @Override
    public void deliver(int amount) {
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public AmountablePrice<IWare> getAmountAndPrice() {
        return this.amountAndPrice;
    }

    @Override
    public IWare getWare() {
        return this.ware;
    }

    @Override
    public int getDeliveredAmount() {
        return this.deliveredAmount;
    }
}

