/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.people.impl;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.model.IMap;
import ch.sahits.game.openpatrician.model.IUpdatableCityRelatedState;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.people.ISmuggler;
import ch.sahits.game.openpatrician.model.people.impl.BaseTavernPerson;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.util.List;
import java.util.Random;
import org.springframework.beans.factory.annotation.Autowired;

@Prototype
@ClassCategory(value={EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
public class SmugglerState
extends BaseTavernPerson
implements ISmuggler,
IUpdatableCityRelatedState {
    @Autowired
    @XStreamOmitField
    private Random rnd;
    @Autowired
    private IMap map;
    private int amount;
    private int premium;
    private ICity destination;

    @Override
    public void update(ICity startCity) {
        this.setAmount(this.rnd.nextInt(200) + 16);
        this.setPremium(this.rnd.nextInt(1000) + 180);
        List<ICity> cities = this.map.getCities();
        ICity nextCity = cities.get(this.rnd.nextInt(cities.size()));
        while (nextCity.equals(startCity)) {
            nextCity = cities.get(this.rnd.nextInt(cities.size()));
        }
        this.setDestination(nextCity);
    }

    @Override
    public int getAmount() {
        return this.amount;
    }

    private void setAmount(int amount) {
        this.amount = amount;
    }

    @Override
    public int getPremium() {
        return this.premium;
    }

    private void setPremium(int premium) {
        this.premium = premium;
    }

    @Override
    public ICity getDestination() {
        return this.destination;
    }

    private void setDestination(ICity destination) {
        this.destination = destination;
    }
}

