/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.people.impl;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.model.IUpdateableState;
import ch.sahits.game.openpatrician.model.people.IPirate;
import ch.sahits.game.openpatrician.model.people.impl.BaseTavernPerson;
import ch.sahits.game.openpatrician.util.RandomNameLoader;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.util.Random;
import org.springframework.beans.factory.annotation.Autowired;

@Prototype
@ClassCategory(value={EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
public class TavernPirateState
extends BaseTavernPerson
implements IPirate,
IUpdateableState {
    @Autowired
    @XStreamOmitField
    private Random rnd;
    private int followers;
    private String name;
    private double profitShare;
    private static RandomNameLoader firstNameLoader = new RandomNameLoader("firstnames.properties");
    private static RandomNameLoader lastNameLoader = new RandomNameLoader("lastnames.properties");

    @Override
    public void update() {
        this.name = firstNameLoader.getRandomName() + " " + lastNameLoader.getRandomName();
        this.followers = this.rnd.nextInt(15) + 12;
        this.profitShare = (double)(this.rnd.nextInt(7) * 5 + 35) / 100.0;
    }

    @Override
    public int getFollowers() {
        return this.followers;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public double getProfitShare() {
        return this.profitShare;
    }
}

