/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.people.impl;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.model.IUpdatableCityRelatedState;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.people.ITrader;
import ch.sahits.game.openpatrician.model.people.impl.BaseTavernPerson;
import ch.sahits.game.openpatrician.model.people.impl.BaseTradePerson;
import ch.sahits.game.openpatrician.model.product.AmountablePrice;
import ch.sahits.game.openpatrician.model.product.EWare;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.model.util.CityUtilities;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.util.Random;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@Prototype
@ClassCategory(value={EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
public class TraderState
extends BaseTavernPerson
implements ITrader,
IUpdatableCityRelatedState {
    @Autowired
    @Qualifier(value="baseTradePerson")
    private BaseTradePerson tradePerson;
    @Autowired
    @XStreamOmitField
    private Random rnd;
    @Autowired
    @XStreamOmitField
    private CityUtilities cityUtils;

    @Override
    public IWare getWare() {
        return this.tradePerson.getWare();
    }

    public void setWare(IWare ware) {
        this.tradePerson.setWare(ware);
    }

    @Override
    public int getAmount() {
        return this.tradePerson.getAmount();
    }

    @Override
    public int getAvgPricePerItem() {
        return this.tradePerson.getAvgPricePerItem();
    }

    public void setAmount(int amount) {
        this.tradePerson.setAmount(amount);
    }

    public void setAvgPricePerItem(int avgPricePerItem) {
        this.tradePerson.setAvgPricePerItem(avgPricePerItem);
    }

    @Override
    public void update(ICity city) {
        EWare ware = EWare.values()[this.rnd.nextInt(EWare.values().length)];
        AmountablePrice<IWare> amountablePrice = city.getWare(ware);
        int availableAmount = amountablePrice.getAmount();
        while (availableAmount == 0) {
            ware = EWare.values()[this.rnd.nextInt(EWare.values().length)];
            availableAmount = city.getWare(ware).getAmount();
        }
        int amount = ware.getSizeAsBarrels() == 1 ? this.rnd.nextInt(100) : this.rnd.nextInt(20);
        amount = Math.max(1, amount);
        this.tradePerson.setAmount(amount);
        double variance = this.rnd.nextDouble() * 0.25 - 0.125;
        int newPrice = (int)Math.abs(Math.rint(variance * (double)ware.computeSellPrice(availableAmount, amount)));
        this.tradePerson.setAvgPricePerItem(newPrice);
        this.tradePerson.setWare(ware);
    }
}

