/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.product;

import ch.sahits.game.openpatrician.model.product.ComputablePrice;
import ch.sahits.game.openpatrician.model.product.EWareSize;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.util.PropertyLoader;
import com.google.common.base.Preconditions;
import java.util.Properties;
import javafx.beans.binding.IntegerBinding;
import javafx.beans.property.IntegerProperty;

public enum EWare implements IWare
{
    BEER("beer.properties"),
    IRONORE("ironore.properties"),
    IRON("iron.properties"),
    FUR("fur.properties"),
    FISH("fish.properties"),
    MEAT("meat.properties"),
    GRAIN("grain.properties"),
    SPICE("spice.properties"),
    HEMP("hemp.properties"),
    WOOD("wood.properties"),
    HONEY("honey.properties"),
    POTTERY("pottery.properties"),
    LEATHER("leather.properties"),
    PITCH("pitch.properties"),
    SALT("salt.properties"),
    FISH_OIL("fishoil.properties"),
    CLOTH("cloth.properties"),
    WINE("wine.properties"),
    WOOL("wool.properties"),
    BRICK("brick.properties");

    private final EWareSize size;
    private final int maxValueBuy;
    private final int minValueBuy;
    private final int maxValueSell;
    private final int minValueSell;
    private final int saturation;
    private final String wareID;
    private final ComputablePrice computablePrice;

    private EWare(String configFileName) {
        Properties props = PropertyLoader.loadProperties((String)configFileName);
        Preconditions.checkNotNull((Object)props.getProperty("type"), (Object)("The property file " + configFileName + " does not contain the type property"));
        Preconditions.checkNotNull((Object)props.getProperty("sizeUnit"), (Object)("The property file " + configFileName + " does not contain the sizeUnit property"));
        Preconditions.checkNotNull((Object)props.getProperty("maxValueBuy"), (Object)("The property file " + configFileName + " does not contain the maxValueBuy property"));
        Preconditions.checkNotNull((Object)props.getProperty("minValueBuy"), (Object)("The property file " + configFileName + " does not contain the minValueBuy property"));
        Preconditions.checkNotNull((Object)props.getProperty("maxValueSell"), (Object)("The property file " + configFileName + " does not contain the maxValueSell property"));
        Preconditions.checkNotNull((Object)props.getProperty("minValueSell"), (Object)("The property file " + configFileName + " does not contain the maxValueSell property"));
        Preconditions.checkNotNull((Object)props.getProperty("localisationID"), (Object)("The property file " + configFileName + " does not contain the localisationID property"));
        Preconditions.checkNotNull((Object)props.getProperty("saturation"), (Object)("The property file " + configFileName + " does not contain the saturation property"));
        this.size = EWareSize.valueOf(props.getProperty("sizeUnit"));
        this.maxValueBuy = Integer.parseInt(props.getProperty("maxValueBuy"));
        this.minValueBuy = Integer.parseInt(props.getProperty("minValueBuy"));
        this.wareID = props.getProperty("localisationID");
        this.saturation = Integer.parseInt(props.getProperty("saturation"));
        this.minValueSell = Integer.parseInt(props.getProperty("minValueSell"));
        this.maxValueSell = Integer.parseInt(props.getProperty("maxValueSell"));
        this.computablePrice = new ComputablePrice(this.maxValueBuy, this.minValueBuy, this.maxValueSell, this.minValueSell, this.saturation, this.name());
    }

    @Override
    public final boolean isBarrelSizedWare() {
        return this.size == EWareSize.BARREL;
    }

    @Override
    public final short getSizeAsBarrels() {
        return this.size.getRealMasurement();
    }

    @Override
    @Deprecated
    public int computeSellPrice(int availableAmount, int amountToSell) {
        return this.computablePrice.computeSellPrice(availableAmount, amountToSell);
    }

    @Override
    @Deprecated
    public int computeBuyPrice(int availableAmount, int amountToBuy) {
        return this.computablePrice.computeBuyPrice(availableAmount, amountToBuy);
    }

    @Override
    public int sellPrice(IntegerProperty availableAmount, IntegerBinding amountToSell) {
        return this.computablePrice.sellPrice(availableAmount, amountToSell);
    }

    @Override
    public int buyPrice(IntegerProperty availableAmount, IntegerBinding amountToBuy) {
        return this.computablePrice.buyPrice(availableAmount, amountToBuy);
    }

    public int computePrice(IntegerProperty available, IntegerBinding amountToBuy) {
        return this.computablePrice.buyPrice(available, amountToBuy);
    }

    @Override
    public int getMaxValueBuy() {
        return this.computablePrice.getMaxValueBuy();
    }

    @Override
    public int getMaxValueSell() {
        return this.computablePrice.getMaxValueSell();
    }

    @Override
    public int getMinValueSell() {
        return this.computablePrice.getMinValueSell();
    }

    @Override
    public int getMinValueBuy() {
        return this.computablePrice.getMinValueBuy();
    }

    @Override
    public int getMarketSaturation() {
        return this.computablePrice.getMarketSaturation();
    }

    public String getWareID() {
        return this.wareID;
    }
}

