/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.spring;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.DependentInitialisation;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.data.map.City;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.time.EUpdateIntervalRegistration;
import ch.sahits.game.openpatrician.model.time.PeriodicalTimeUpdaterV2;
import ch.sahits.game.openpatrician.util.RandomNameLoader;
import ch.sahits.game.openpatrician.util.StartNewGameBean;
import java.util.Locale;
import java.util.Random;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.beans.factory.config.PropertiesFactoryBean;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Scope;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.oxm.jaxb.Jaxb2Marshaller;

@Configuration
@ComponentScan(basePackages={"ch.sahits.game.openpatrician.model", "ch.sahits.game.openpatrician.util", "ch.sahits.game.openpatrician.persistence.converter"})
@ClassCategory(value={EClassCategory.STARTUP})
public class ModelConfiguration {
    @Autowired
    private Environment standardEnvironment;

    @Bean
    public Random rnd() {
        return new Random();
    }

    @Bean
    public Jaxb2Marshaller jaxb2MapMarshaller() {
        Jaxb2Marshaller bean = new Jaxb2Marshaller();
        bean.setContextPath("ch.sahits.game.openpatrician.data.map");
        return bean;
    }

    @Bean
    public static PropertyPlaceholderConfigurer applicationProperties(@Value(value="#{systemProperties['user.home']}") String userHome) {
        PropertyPlaceholderConfigurer bean = new PropertyPlaceholderConfigurer();
        bean.setIgnoreUnresolvablePlaceholders(true);
        bean.setLocations(new Resource[]{new ClassPathResource("model-settings.properties"), new FileSystemResource(userHome + "/.OpenPatrician/OpenPatricianConfiguration.properties")});
        return bean;
    }

    @Bean
    public static PropertyPlaceholderConfigurer difficulty() {
        PropertyPlaceholderConfigurer bean = new PropertyPlaceholderConfigurer();
        bean.setIgnoreUnresolvablePlaceholders(true);
        bean.setLocations(new Resource[]{new ClassPathResource("difficulty_level_easy.properties")});
        return bean;
    }

    @Bean
    public PropertiesFactoryBean model() {
        PropertiesFactoryBean bean = new PropertiesFactoryBean();
        bean.setLocation((Resource)new ClassPathResource("populationConsume_default.properties"));
        return bean;
    }

    @Bean
    public Locale defaultLocale() {
        return Locale.ENGLISH;
    }

    @Bean
    public RandomNameLoader firstNameLoader() {
        return new RandomNameLoader("firstnames.properties");
    }

    @Bean
    public RandomNameLoader lastNameLoader() {
        return new RandomNameLoader("lastnames.properties");
    }

    @Bean
    public RandomNameLoader shipNameLoader() {
        return new RandomNameLoader("shipnames.properties");
    }

    @Bean
    public PropertiesFactoryBean modelProperties() {
        PropertiesFactoryBean propertyFact = new PropertiesFactoryBean();
        propertyFact.setLocation((Resource)new ClassPathResource("model.properties"));
        return propertyFact;
    }

    @Bean
    @Scope(value="prototype")
    public ICity cityBean(City cityData) {
        return new ch.sahits.game.openpatrician.model.city.impl.City(cityData);
    }

    @Bean
    public ReloadableResourceBundleMessageSource messageSource() {
        ReloadableResourceBundleMessageSource bundle = new ReloadableResourceBundleMessageSource();
        bundle.setDefaultEncoding("UTF-8");
        bundle.setBasename("i18n/text");
        return bundle;
    }

    @Bean
    @Lazy
    @DependentInitialisation(value=StartNewGameBean.class, registerWithBeanName=true)
    public PeriodicalTimeUpdaterV2 periodicalEndOfDayUpdater() {
        return new PeriodicalTimeUpdaterV2(EUpdateIntervalRegistration.END_OF_DAY);
    }

    @Bean
    @Lazy
    @DependentInitialisation(value=StartNewGameBean.class, registerWithBeanName=true)
    public PeriodicalTimeUpdaterV2 periodicalEndOfWeekUpdater() {
        return new PeriodicalTimeUpdaterV2(EUpdateIntervalRegistration.END_OF_WEEK);
    }

    @Bean
    @Lazy
    @DependentInitialisation(value=StartNewGameBean.class, registerWithBeanName=true)
    public PeriodicalTimeUpdaterV2 periodicalEndOfMonthUpdater() {
        return new PeriodicalTimeUpdaterV2(EUpdateIntervalRegistration.END_OF_MONTH);
    }

    @Bean
    @Lazy
    @DependentInitialisation(value=StartNewGameBean.class, registerWithBeanName=true)
    public PeriodicalTimeUpdaterV2 periodicalEndOfYearUpdater() {
        return new PeriodicalTimeUpdaterV2(EUpdateIntervalRegistration.END_OF_YEAR);
    }

    @Bean
    @Lazy
    @DependentInitialisation(value=StartNewGameBean.class, registerWithBeanName=true)
    public PeriodicalTimeUpdaterV2 periodicalWeeklyUpdater() {
        return new PeriodicalTimeUpdaterV2(EUpdateIntervalRegistration.WEEK);
    }
}

