/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.util;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.LazySingleton;
import ch.sahits.game.openpatrician.annotation.ListType;
import ch.sahits.game.openpatrician.data.map.Map;
import ch.sahits.game.openpatrician.data.map.MapSegments;
import ch.sahits.game.openpatrician.data.map.PirateNest;
import ch.sahits.game.openpatrician.data.map.SunkenTreasure;
import ch.sahits.game.openpatrician.model.MapSegmentedImage;
import ch.sahits.game.openpatrician.model.city.CityFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javafx.geometry.Point2D;
import org.springframework.beans.factory.annotation.Autowired;

@LazySingleton
@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public class MapSegmentImageFactory {
    @Autowired
    private Random rnd;
    @Autowired
    private CityFactory cityFactory;
    @ListType(value=MapSegmentedImage.class)
    private List<MapSegmentedImage> pirateHideOuts;
    @ListType(value=MapSegmentedImage.class)
    private List<MapSegmentedImage> sunkShips;

    public void initializeImages() {
        Map map = this.cityFactory.getMap();
        this.pirateHideOuts = new ArrayList<MapSegmentedImage>();
        this.sunkShips = new ArrayList<MapSegmentedImage>();
        MapSegments mapSegments = map.getMapSegments();
        for (PirateNest pirateNest : mapSegments.getPirateNest()) {
            this.pirateHideOuts.add(new MapSegmentedImage(pirateNest.getSegment(), new Point2D((double)pirateNest.getX().shortValue(), (double)pirateNest.getX().shortValue())));
        }
        for (SunkenTreasure sunkenTreasure : mapSegments.getSunkenTreasure()) {
            this.sunkShips.add(new MapSegmentedImage(sunkenTreasure.getSegment(), new Point2D((double)sunkenTreasure.getX().shortValue(), (double)sunkenTreasure.getX().shortValue())));
        }
    }

    public MapSegmentedImage getRandomPirateNest() {
        return this.getRandomImage(this.pirateHideOuts);
    }

    public MapSegmentedImage getRandomTreasureNest() {
        return this.getRandomImage(this.sunkShips);
    }

    private MapSegmentedImage getRandomImage(List<MapSegmentedImage> imgList) {
        MapSegmentedImage img = imgList.get(this.rnd.nextInt(imgList.size()));
        int availableSegment = this.rnd.nextInt(9);
        img.addSegment(availableSegment);
        return img;
    }
}

