package ch.sahits.game.openpatrician.model;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import javafx.geometry.Point2D;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2015
 *         Created on Dec 07, 2015
 */
@ClassCategory({EClassCategory.MODEL, EClassCategory.DEPENDS_ON_SERIALIZED_BEAN})
@EqualsAndHashCode
public class PirateMapSegmentImage extends MapSegmentedImage {
    @Getter
    @Setter
    private int amountOfShips; // TODO: 12/7/15 this should become a list of ships
    @Getter
    private String name = "Evil Pirate";
    public PirateMapSegmentImage(String imageName, Point2D location, int nbShips, String name) {
        super(imageName, location);
        amountOfShips = nbShips;
        this.name = name;
    }
}
