package ch.sahits.game.openpatrician.model.building;

import ch.sahits.game.openpatrician.model.IPlayer;


/**
 * Basic definition of a building.
 * @author Andi Hotz, (c) Sahits GmbH, 2011
 * Created on Dec 17, 2011
 *
 */
public interface IBuilding {
	/**
	 * Retrieve the owner of the trading office
	 * @return
	 */
	IPlayer getOwner();
	/**
	 * Retrieve the amount of property taxes per week
	 * @return
	 */
	int getPropertyTax();
	/**
	 * Retrieve the value of the building
	 * @return
	 */
	int getValue();

	/**
	 * Execute when the building is destroyed.
	 */
	void destroy();
}
