package ch.sahits.game.openpatrician.model.building;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.LazySingleton;
import ch.sahits.game.openpatrician.annotation.ListType;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/**
 * List holding the trading offices.
 * @author Andi Hotz, (c) Sahits GmbH, 2015
 *         Created on Aug 28, 2015
 */
@LazySingleton
@ClassCategory({EClassCategory.SINGLETON_BEAN, EClassCategory.SERIALIZABLE_BEAN})
public class TradingOfficeList implements Iterable<ITradingOffice> {
    @ListType(ITradingOffice.class)
    private List<ITradingOffice> offices = new ArrayList<>();

    @Override
    public Iterator<ITradingOffice> iterator() {
        return offices.iterator();
    }

    public boolean add(ITradingOffice iTradingOffice) {
        return offices.add(iTradingOffice);
    }
}
