package ch.sahits.game.openpatrician.model.city;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.LazySingleton;
import ch.sahits.game.openpatrician.annotation.ListType;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/**
 * List for all loaners.
 * @author Andi Hotz, (c) Sahits GmbH, 2015
 *         Created on Aug 28, 2015
 */
@LazySingleton
@ClassCategory({EClassCategory.SINGLETON_BEAN, EClassCategory.SERIALIZABLE_BEAN})
public class LoanerList implements Iterable<ILoaner> {
    @ListType(ILoaner.class)
    private List<ILoaner> loaners = new ArrayList<>();

    @Override
    public Iterator<ILoaner> iterator() {
        return loaners.iterator();
    }

    public boolean add(ILoaner iLoaner) {
        return loaners.add(iLoaner);
    }
}
