package ch.sahits.game.openpatrician.model.city.cityhall;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.LazySingleton;
import ch.sahits.game.openpatrician.annotation.MapType;
import ch.sahits.game.openpatrician.model.IPlayer;

import java.util.HashMap;
import java.util.Map;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2015
 *         Created on Aug 27, 2015
 */
@LazySingleton
@ClassCategory({EClassCategory.SINGLETON_BEAN, EClassCategory.SERIALIZABLE_BEAN})
public class AldermanTaskPlayerMap {
    /**
     * List of alderman tasks that were taken and must be checked.
     */
    @MapType(key = IAldermanTask.class, value = IPlayer.class)
    private Map<IAldermanTask, IPlayer> takenTasks = new HashMap<>();

    public void assignTask(IPlayer player, IAldermanTask task) {
        takenTasks.put(task, player);
    }
}
