package ch.sahits.game.openpatrician.model.city.cityhall.impl;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.cityhall.IAcceptedAldermanTask;
import ch.sahits.game.openpatrician.model.city.cityhall.IAldermanTask;
import lombok.Getter;
import org.joda.time.DateTime;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2015
 *         Created on Jun 06, 2015
 */
@ClassCategory(EClassCategory.DEPENDS_ON_SERIALIZED_BEAN)
public class AcceptedAldermanTask implements IAcceptedAldermanTask {
    @Getter
    private final IAldermanTask task;
    @Getter
    private final DateTime deadline;
    @Getter
    private final IPlayer player;

    public AcceptedAldermanTask(IAldermanTask task, DateTime deadline, IPlayer player) {
        this.task = task;
        this.deadline = deadline;
        this.player = player;
    }
}
