package ch.sahits.game.openpatrician.model.people.impl;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.model.AUpdatableCityRelated;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.people.ISmuggler;
import lombok.Getter;
import lombok.Setter;

/**
 * Implementation of a smuggler. Every city can have a smuggler and is referenced
 * through it's TavernEngine.
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 * Created on Jan 20, 2013
 *
 */
@Prototype
@ClassCategory({EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
@AUpdatableCityRelated
public class SmugglerState extends BaseTavernPerson implements ISmuggler {
    @Getter
    @Setter
	private int amount;
    @Getter
    @Setter
	private int premium;
    @Getter
    @Setter
	private ICity destination;


}
