package ch.sahits.game.openpatrician.model.sea;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.MapType;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import javafx.geometry.Point2D;
import javafx.scene.shape.Path;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2016
 *         Created on Jan 08, 2016
 */
@ClassCategory({EClassCategory.SERIALIZABLE_BEAN, EClassCategory.SINGLETON_BEAN})
@Component
@Lazy
public class TravellingVessels implements Iterable<INavigableVessel> {
    @MapType(key = INavigableVessel.class, value = TravellingVessel.class)
    private final Map<INavigableVessel, TravellingVessel> vessels = new ConcurrentHashMap<>();

    public void addVessel(INavigableVessel vessel, Path path, List<Point2D> points, boolean visibleOnMap) {
        TravellingVessel tv = new TravellingVessel(vessel);
        tv.setCalculatablePath(points);
        tv.setDrwawablePath(path);
        tv.setDisplayVessel(visibleOnMap);
        vessels.put(vessel, tv);
    }
    public void remove(INavigableVessel vessel) {
        vessels.remove(vessel);
    }

    @Override
    public Iterator<INavigableVessel> iterator() {
        return vessels.keySet().iterator();
    }

    public TravellingVessel getTravellingVessel(INavigableVessel vessel) {
        return vessels.get(vessel);
    }
}
