package ch.sahits.game.openpatrician.model.service;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.LazySingleton;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.model.weapon.EWeapon;

import java.util.List;
import java.util.Optional;

/**
 * Service class for ships.
 * @author Andi Hotz, (c) Sahits GmbH, 2015
 *         Created on Dec 26, 2015
 */
@LazySingleton
@ClassCategory(EClassCategory.SINGLETON_BEAN)
public class ShipService {
    /**
     * Calculate the total strength of the ships weapons.
     * @param ship for which the strengths should be calculated
     * @return total strength.
     */
    public int calculateShipsWeaponsStrength(INavigableVessel ship) {
        int strength = 0;
        strength += ship.getWeaponAmount(EWeapon.BALLISTA_BIG) * 2;
        strength += ship.getWeaponAmount(EWeapon.TREBUCHET_BIG) * 2;
        strength += ship.getWeaponAmount(EWeapon.CANNON) * 2;
        strength += ship.getWeaponAmount(EWeapon.BOMBARD) * 2;
        strength += ship.getWeaponAmount(EWeapon.BALLISTA_SMALL);
        strength += ship.getWeaponAmount(EWeapon.TREBUCHET_SMALL);
        return strength;
    }

    /**
     * Find the ship that matches the UUID within a list of ships.
     * @param fleet list of navigable vessels
     * @param uuid to be looked up
     * @return Optional wrapped around the found vessel of an empty Optional if no vessel can be matched.
     */
    public Optional<INavigableVessel> findShipByUuid(List<INavigableVessel> fleet, String uuid) {
        for (INavigableVessel vessel : fleet) {
            if (uuid.equals(vessel.getUuid())) {
                return Optional.of(vessel);
            }
        }
        return Optional.empty();
    }
}
