package ch.sahits.game.openpatrician.model.ship;

import ch.sahits.game.openpatrician.model.IPlayer;

import java.util.List;
import java.util.Map;

/**
 * A convoy is a special representation of a ship. A convoy is put together
 * by a lead ship and optionally other ships. These ships may belong to other
 * players. Any gain or loss will be distributed unto the ships according to their
 * capacity.
 * @author Andi Hotz, (c) Sahits GmbH, 2011
 * Created on Dec 17, 2011
 *
 */
public interface IConvoy extends INavigableVessel {
	/**
	 * Though a convoy has always weapons this is only something that
	 * is handled on the level of a single ship. Therefore this method
	 * will always return false.
	 * @return false
	 */
	boolean hasWeapons();

	/**
	 * Retrieve the lead ship of the convoy.
	 * @return
     */
	IShip getOrlegShip();

	/**
	 * Retrieve a list of the ships in the convoy.
	 * @return
     */
	List<IShip> getShips();

    /**
     * Get all the ships in the convoi that belong to a player.
     * @param player who owns the ships
     * @return possible empty list of ships.
     */
    List<IShip> getShips(IPlayer player);

    /**
     * Get all players who have a ship in the convoy.
     * @return list of players.
     */
    List<IPlayer> getPlayers();

	/**
	 * Add a ship to the convoy.
	 * @param ship to be added.
     */
	void addShip(IShip ship);

	/**
	 * Remove a ship from the convoy.
	 * @param ship to be removed.
     */
	void removeShip(IShip ship);

    /**
     * Collect the convoys capacity per player who has ships
     * in the convoy.
     * @return map of IPlayer to capacity.
     */
    Map<IPlayer,Integer> getCapacityPerOwner();

	/**
	 * Indicates that everyone can join this convoy.
	 * @return
     */
	boolean isPublicConvoy();
}
