/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.building.impl;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.MapType;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.model.building.ETradeType;
import ch.sahits.game.openpatrician.model.building.IAutomatedTrading;
import ch.sahits.game.openpatrician.model.building.impl.TradableWare;
import ch.sahits.game.openpatrician.model.product.EWare;
import ch.sahits.game.openpatrician.model.product.IWare;
import java.util.HashMap;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;

@Prototype
@ClassCategory(value={EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
public class AutomatedTrading
implements IAutomatedTrading {
    @MapType(key=IWare.class, value=TradableWare.class)
    private HashMap<IWare, TradableWare> wares = new HashMap();

    public AutomatedTrading() {
        for (EWare ware : EWare.values()) {
            this.wares.put(ware, new TradableWare());
        }
    }

    @Override
    public int getAmount(IWare ware) {
        return this.wares.get(ware).getAmount();
    }

    @Override
    public IntegerProperty amountProperty(IWare ware) {
        return this.wares.get(ware).amountProperty();
    }

    @Override
    public int getPrice(IWare ware) {
        return this.wares.get(ware).getPrice();
    }

    @Override
    public IntegerProperty priceProperty(IWare ware) {
        return this.wares.get(ware).priceProperty();
    }

    @Override
    public ObjectProperty<ETradeType> tradingTypeProperty(IWare ware) {
        return this.wares.get(ware).tradeTypeProperty();
    }

    @Override
    public boolean isMovableToShip(IWare ware) {
        return this.wares.get(ware).isMovable2Ship();
    }

    @Override
    public BooleanProperty movableToShipProperty(IWare ware) {
        return this.wares.get(ware).moveable2ShipProperty();
    }

    @Override
    public void updateAmount(IWare ware, int difference) {
        TradableWare tw = this.wares.get(ware);
        tw.setAmount(tw.getAmount() + difference);
    }

    @Override
    public void updatePrice(IWare ware, int difference) {
        TradableWare tw = this.wares.get(ware);
        tw.setPrice(tw.getPrice() + difference);
    }

    @Override
    public void setTradingType(IWare ware, ETradeType tt) {
        this.wares.get(ware).setTradingType(tt);
    }

    @Override
    public void setMovableToShip(IWare ware, boolean isMovable) {
        this.wares.get(ware).setMovable2Ship(isMovable);
    }
}

