/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.building.impl;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.MapType;
import ch.sahits.game.openpatrician.model.BaseAmountable;
import ch.sahits.game.openpatrician.model.building.IWeaponStorage;
import ch.sahits.game.openpatrician.model.weapon.EWeapon;
import ch.sahits.game.openpatrician.model.weapon.IWeapon;
import java.util.Hashtable;

@ClassCategory(value={EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
public class WeaponStorage
implements IWeaponStorage {
    @MapType(key=IWeapon.class, value=BaseAmountable.class)
    private Hashtable<IWeapon, BaseAmountable<IWeapon>> storage = new Hashtable();

    public WeaponStorage() {
        for (EWeapon weapon : EWeapon.values()) {
            BaseAmountable amountable = new BaseAmountable();
            this.storage.put(weapon, amountable);
        }
    }

    @Override
    public int getWeapon(IWeapon weapon) {
        return this.storage.get(weapon).getAmount();
    }

    @Override
    public int update(IWeapon weapon, int amount) {
        BaseAmountable<IWeapon> amountable = this.storage.get(weapon);
        int available = amountable.getAmount();
        if (amount < 0) {
            if (available < -amount) {
                amount = -available;
            }
            amountable.remove(amount);
        } else {
            amountable.add(amount);
        }
        return amount;
    }

    @Override
    public boolean hasWeapons() {
        for (BaseAmountable<IWeapon> amount : this.storage.values()) {
            if (amount.getAmount() <= 0) continue;
            return true;
        }
        return false;
    }
}

