/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.city.impl;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.MultimapType;
import ch.sahits.game.openpatrician.annotation.UniquePrototype;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.city.impl.Contribution;
import ch.sahits.game.openpatrician.model.product.IWare;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.Iterator;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.springframework.beans.factory.annotation.Autowired;

@UniquePrototype
@ClassCategory(value={EClassCategory.SERIALIZABLE_BEAN, EClassCategory.SINGLETON_BEAN})
public class Contributions {
    @Autowired
    private Date date;
    @MultimapType(key=IWare.class, value=Contribution.class)
    private Multimap<IWare, Contribution> contributions = ArrayListMultimap.create();

    public int getContribution(IWare ware) {
        int sum = 0;
        DateTime lastWeek = this.date.getCurrentDate().minusDays(7);
        Iterator iterator = this.contributions.get((Object)ware).iterator();
        while (iterator.hasNext()) {
            Contribution contrib = (Contribution)iterator.next();
            if (contrib.getTimestamp().isBefore((ReadableInstant)lastWeek)) {
                iterator.remove();
                continue;
            }
            sum += contrib.getAmount();
        }
        return sum;
    }

    public void contribute(IWare ware, int amount) {
        DateTime now = this.date.getCurrentDate();
        DateTime lastWeek = this.date.getCurrentDate().minusDays(7);
        if (this.contributions.containsKey((Object)ware)) {
            Iterator iterator = this.contributions.get((Object)ware).iterator();
            while (iterator.hasNext()) {
                Contribution contrib = (Contribution)iterator.next();
                if (!contrib.getTimestamp().isBefore((ReadableInstant)lastWeek)) continue;
                iterator.remove();
            }
        }
        this.contributions.put((Object)ware, (Object)new Contribution(now, amount, ware));
    }
}

