/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.people.impl;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.LazySingleton;
import ch.sahits.game.openpatrician.annotation.MultimapType;
import ch.sahits.game.openpatrician.annotation.SetType;
import ch.sahits.game.openpatrician.model.IMap;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.people.ISeaPirate;
import ch.sahits.game.openpatrician.model.people.impl.SeaPirate;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.model.ship.ShipFactory;
import ch.sahits.game.openpatrician.util.RandomNameLoader;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import javafx.geometry.Point2D;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;

@LazySingleton
@ClassCategory(value={EClassCategory.SERIALIZABLE_BEAN, EClassCategory.SINGLETON_BEAN})
public class SeaPiratesState {
    @Autowired
    @XStreamOmitField
    private Random rnd;
    @Autowired
    @XStreamOmitField
    private ShipFactory shipFactory;
    @Autowired
    private IMap map;
    @MultimapType(key=IPlayer.class, value=ISeaPirate.class)
    private Multimap<IPlayer, ISeaPirate> nonFreePirates = ArrayListMultimap.create();
    @SetType(value=ISeaPirate.class)
    private Set<ISeaPirate> freePirates = Sets.newHashSet();
    private static RandomNameLoader firstNameLoader = new RandomNameLoader("pirate_firstnames.properties");
    private static RandomNameLoader lastNameLoader = new RandomNameLoader("pirate_lastnames.properties");
    private static RandomNameLoader shipLoader = new RandomNameLoader("shipnames.properties");

    @PostConstruct
    public void init() {
        String name = firstNameLoader.getRandomName() + " " + lastNameLoader.getRandomName();
        IShip ship = this.createInitialPiratesShip();
        ISeaPirate pirate = this.createNewPirate(name, ship, true);
        Optional<IPlayer> absent = Optional.empty();
        this.add(pirate, absent);
    }

    private IShip createInitialPiratesShip() {
        int shipChoice = this.rnd.nextInt(3);
        IShip ship = null;
        switch (shipChoice) {
            case 0: {
                ship = this.shipFactory.createSnaikka(shipLoader.getRandomName(), 0);
                break;
            }
            case 1: {
                ship = this.shipFactory.createCrayer(shipLoader.getRandomName(), 0);
                break;
            }
            case 2: {
                ship = this.shipFactory.createHolk(shipLoader.getRandomName(), 0);
                break;
            }
            default: {
                throw new RuntimeException("Should never get here");
            }
        }
        return ship;
    }

    public void add(ISeaPirate pirate, Optional<IPlayer> player) {
        if (player.isPresent()) {
            this.nonFreePirates.put((Object)player.get(), (Object)pirate);
        } else {
            this.freePirates.add(pirate);
        }
    }

    public void free(IPlayer player, ISeaPirate pirate) {
        this.nonFreePirates.remove((Object)player, (Object)pirate);
        this.freePirates.add(pirate);
    }

    public List<ISeaPirate> getNonFreePirates(IPlayer player) {
        return ImmutableList.copyOf((Collection)this.nonFreePirates.get((Object)player));
    }

    public Set<ISeaPirate> getFreePirates() {
        return ImmutableSet.copyOf(this.freePirates);
    }

    public ISeaPirate createNewPirate(String name, IShip ship, boolean wholeHanse) {
        SeaPirate pirate = new SeaPirate();
        pirate.setName(name);
        pirate.setShip(ship);
        pirate.setWholeHanse(wholeHanse);
        pirate.moveTo(new Point2D(50.0, 50.0));
        return pirate;
    }

    public ISeaPirate createNewPirate(String name, IShip ship, Point2D near, boolean wholeHanse) {
        SeaPirate pirate = (SeaPirate)this.createNewPirate(name, ship, wholeHanse);
        double newX = Math.min(Math.max((double)(this.rnd.nextInt(100) - 50) + near.getX(), 0.0), this.map.getDimension().getWidth());
        double newY = Math.min(Math.max((double)(this.rnd.nextInt(100) - 50) + near.getY(), 0.0), this.map.getDimension().getHeight());
        Point2D p = new Point2D(newX, newY);
        pirate.moveTo(p);
        return pirate;
    }

    public ISeaPirate findSuccessfulPirate() {
        int maxKill = 0;
        ISeaPirate successful = null;
        for (ISeaPirate pirate : this.freePirates) {
            if (pirate.getNumberOfKills() < maxKill) continue;
            successful = pirate;
            maxKill = pirate.getNumberOfKills();
        }
        return successful;
    }
}

