/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.personal.impl;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.personal.IPersonalData;
import java.beans.ConstructorProperties;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.Years;

@ClassCategory(value={EClassCategory.DEPENDS_ON_SERIALIZED_BEAN})
public class PersonalData
implements IPersonalData {
    private final String name;
    private final String lastName;
    private final boolean male;
    private final ICity birthPlace;
    private final DateTime birthDate;

    @Override
    public int getAge(DateTime now) {
        return Years.yearsBetween((ReadableInstant)this.birthDate, (ReadableInstant)now).getYears();
    }

    @ConstructorProperties(value={"name", "lastName", "male", "birthPlace", "birthDate"})
    public PersonalData(String name, String lastName, boolean male, ICity birthPlace, DateTime birthDate) {
        this.name = name;
        this.lastName = lastName;
        this.male = male;
        this.birthPlace = birthPlace;
        this.birthDate = birthDate;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getLastName() {
        return this.lastName;
    }

    @Override
    public boolean isMale() {
        return this.male;
    }

    @Override
    public ICity getBirthPlace() {
        return this.birthPlace;
    }

    @Override
    public DateTime getBirthDate() {
        return this.birthDate;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PersonalData)) {
            return false;
        }
        PersonalData other = (PersonalData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$lastName = this.getLastName();
        String other$lastName = other.getLastName();
        if (this$lastName == null ? other$lastName != null : !this$lastName.equals(other$lastName)) {
            return false;
        }
        if (this.isMale() != other.isMale()) {
            return false;
        }
        ICity this$birthPlace = this.getBirthPlace();
        ICity other$birthPlace = other.getBirthPlace();
        if (this$birthPlace == null ? other$birthPlace != null : !this$birthPlace.equals(other$birthPlace)) {
            return false;
        }
        DateTime this$birthDate = this.getBirthDate();
        DateTime other$birthDate = other.getBirthDate();
        return !(this$birthDate == null ? other$birthDate != null : !this$birthDate.equals(other$birthDate));
    }

    public boolean canEqual(Object other) {
        return other instanceof PersonalData;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        String $name = this.getName();
        result = result * 31 + ($name == null ? 0 : $name.hashCode());
        String $lastName = this.getLastName();
        result = result * 31 + ($lastName == null ? 0 : $lastName.hashCode());
        result = result * 31 + (this.isMale() ? 1231 : 1237);
        ICity $birthPlace = this.getBirthPlace();
        result = result * 31 + ($birthPlace == null ? 0 : $birthPlace.hashCode());
        DateTime $birthDate = this.getBirthDate();
        result = result * 31 + ($birthDate == null ? 0 : $birthDate.hashCode());
        return result;
    }
}

