/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.ship.impl;

import ch.sahits.game.openpatrician.annotation.MapType;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.collections.NonReplacableMap;
import ch.sahits.game.openpatrician.javafx.bindings.LateIntegerBinding;
import ch.sahits.game.openpatrician.model.people.ICaptain;
import ch.sahits.game.openpatrician.model.people.IPerson;
import ch.sahits.game.openpatrician.model.people.IShipOwner;
import ch.sahits.game.openpatrician.model.product.AmountablePrice;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.model.ship.EShipSide;
import ch.sahits.game.openpatrician.model.ship.EShipUpgrade;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.model.ship.IShipWeaponsLocation;
import ch.sahits.game.openpatrician.model.weapon.IWeapon;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import javafx.beans.Observable;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.IntegerBinding;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.geometry.Point2D;

@Prototype
public abstract class Ship
implements IShip {
    private static final double SAILOR_NEEDS_SPACE = 0.5;
    protected EShipUpgrade shipUpgradeLevel;
    protected String name;
    @MapType(key=IWare.class, value=AmountablePrice.class)
    private Map<IWare, AmountablePrice<IWare>> loadedWare = new NonReplacableMap();
    @XStreamOmitField
    private LateIntegerBinding loadBinding = this.createLoadBinding();
    private final double topSpeed;
    @XStreamOmitField
    private BooleanBinding passengerPresent = new BooleanBinding(){

        protected boolean computeValue() {
            return Ship.this.passenger.isPresent();
        }
    };
    @MapType(key=IWeapon.class, value=Integer.class)
    private Map<IWeapon, Integer> loadedWeapons = Maps.newHashMap();
    private IShipWeaponsLocation shipWeaponsLocation;
    private final int initialValue;
    private final int minNumberOfSailors;
    private final int maxSailors;
    private Optional<ICaptain> captian = Optional.empty();
    private Optional<IPerson> passenger = Optional.empty();
    protected int fitness = 100;
    private IntegerProperty nbSailors = new SimpleIntegerProperty(0);
    private Point2D location = null;
    private IShipOwner owner = null;
    private boolean piratingShip = false;
    private boolean available = true;
    private int occupiedSpace;
    private int size;
    private int reductionLevel1;
    private int reductionLevel2;
    private final String uuid;

    protected Ship(Properties shipConfiguration) {
        this.initialValue = Integer.parseInt(shipConfiguration.getProperty("initialValue"));
        this.minNumberOfSailors = Integer.parseInt(shipConfiguration.getProperty("minNumberOfSailors"));
        this.maxSailors = Integer.parseInt(shipConfiguration.getProperty("maxSailors"));
        this.size = Integer.parseInt(shipConfiguration.getProperty("size"));
        this.reductionLevel1 = Integer.parseInt(shipConfiguration.getProperty("reductionLevel1"));
        this.reductionLevel2 = Integer.parseInt(shipConfiguration.getProperty("reductionLevel2"));
        this.topSpeed = Double.parseDouble(shipConfiguration.getProperty("speedkmperh"));
        this.uuid = UUID.randomUUID().toString();
    }

    Ship(int initialValue, int minNumberOfSailors, int maxSailors) {
        this.initialValue = initialValue;
        this.minNumberOfSailors = minNumberOfSailors;
        this.maxSailors = maxSailors;
        this.topSpeed = 5.0;
        this.uuid = UUID.randomUUID().toString();
    }

    protected Ship() {
        this.initialValue = 0;
        this.minNumberOfSailors = 0;
        this.maxSailors = 0;
        this.topSpeed = 5.0;
        this.uuid = UUID.randomUUID().toString();
    }

    @Override
    public int getMaxNumberOfSailors() {
        int availableSpace = this.getCapacity();
        int spaceForSailors = (int)Math.rint((double)availableSpace / 0.5);
        return Math.min(this.maxSailors, spaceForSailors);
    }

    @Override
    public void setCaptain(ICaptain captain) {
        this.captian = Optional.ofNullable(captain);
    }

    @Override
    public boolean isUpgradable() {
        return this.shipUpgradeLevel != EShipUpgrade.LEVEL2;
    }

    @Override
    public void upgrade() {
        EShipUpgrade[] levels = EShipUpgrade.values();
        for (int i = 0; i < levels.length; ++i) {
            if (levels[i] != this.shipUpgradeLevel) continue;
            this.shipUpgradeLevel = levels[i + 1];
            break;
        }
    }

    @Override
    public Set<IWare> getLoadedWares() {
        return this.loadedWare.keySet();
    }

    @Override
    public int load(IWare ware, int amount, int avgPrice) {
        short sizeInBarrels = ware.getSizeAsBarrels();
        int cap = this.ensureCapacity((amount = Math.abs(amount)) * sizeInBarrels);
        if (cap != amount && sizeInBarrels != 1) {
            cap = cap / sizeInBarrels * sizeInBarrels;
        }
        AmountablePrice<IWare> available = this.getWare(ware);
        available.add(cap / ware.getSizeAsBarrels(), avgPrice);
        return cap / sizeInBarrels;
    }

    private int ensureCapacity(int amount) {
        return Math.min(amount, this.getCapacity());
    }

    @Override
    public int unload(IWare ware, int amount) {
        if (!this.loadedWare.containsKey(ware)) {
            return 0;
        }
        amount = Math.abs(amount);
        int loaded = this.loadedWare.get(ware).getAmount() * ware.getSizeAsBarrels();
        int unloaded = Math.min(loaded, amount *= ware.getSizeAsBarrels());
        if (unloaded == loaded) {
            AmountablePrice<IWare> available = this.loadedWare.get(ware);
            available.reset();
        } else {
            AmountablePrice<IWare> available = this.loadedWare.get(ware);
            available.remove(unloaded / ware.getSizeAsBarrels());
        }
        return unloaded / ware.getSizeAsBarrels();
    }

    private int internalLoadCalculation() {
        int sum = 0;
        for (Map.Entry<IWare, AmountablePrice<IWare>> entry : this.loadedWare.entrySet()) {
            int amount = entry.getValue().getAmount();
            short barrelSize = entry.getKey().getSizeAsBarrels();
            sum += amount * barrelSize;
        }
        return sum;
    }

    @Override
    public IntegerBinding getLoadBinding() {
        return this.loadBinding;
    }

    protected void clearLoadedWares() {
        for (AmountablePrice<IWare> amountable : this.loadedWare.values()) {
            amountable.reset();
        }
    }

    @Override
    public AmountablePrice<IWare> getWare(IWare ware) {
        if (!this.loadedWare.containsKey(ware)) {
            AmountablePrice amountable = new AmountablePrice();
            this.loadedWare.put(ware, amountable);
            this.loadBinding.bind((Observable)amountable.amountProperty());
        }
        return this.loadedWare.get(ware);
    }

    private EShipSide getNextFreeSide(IWeapon weapon) {
        return null;
    }

    private int getNextFreeSlot(IWeapon weapon, EShipSide side) {
        return -1;
    }

    @Override
    public boolean hasWeapons() {
        return false;
    }

    @Override
    public int getValue() {
        return (int)Math.rint((double)(this.initialValue * this.fitness) / 100.0);
    }

    @Override
    public int getNumberOfSailors() {
        return this.nbSailors.get();
    }

    @Override
    public void setNumberOfSailors(int nbSailors) {
        this.nbSailors.set(nbSailors);
    }

    @Override
    public IntegerProperty numberOfSailorsProperty() {
        return this.nbSailors;
    }

    @Override
    public void move(IWeapon weaponType, int amount) {
        if (!this.loadedWeapons.containsKey(weaponType)) {
            this.loadedWeapons.put(weaponType, 0);
        }
        if (amount < 0) {
            boolean check = -amount <= this.loadedWeapons.get(weaponType);
            Preconditions.checkArgument((boolean)check, (Object)"Cannot remove more than available");
        }
        int amountable = this.loadedWeapons.get(weaponType);
        this.loadedWeapons.put(weaponType, amountable + amount);
    }

    @Override
    public int getWeaponAmount(IWeapon weaponType) {
        if (this.loadedWeapons.containsKey(weaponType)) {
            return this.loadedWeapons.get(weaponType);
        }
        return 0;
    }

    @Override
    public void addPassenger(IPerson passanger) {
        Preconditions.checkArgument((!this.passenger.isPresent() ? 1 : 0) != 0, (Object)"Passenger already present");
        this.passenger = Optional.of(passanger);
        this.passengerPresent.invalidate();
    }

    @Override
    public IShipOwner getOwner() {
        return this.owner;
    }

    @Override
    public void leavePassanger() {
        this.passenger = Optional.empty();
        this.passengerPresent.invalidate();
    }

    @Override
    public int getCapacity() {
        int passengerSpace = this.passenger.isPresent() ? 30 : 0;
        return this.size - this.getUpgradeSpaceReduction() - this.internalLoadCalculation() - this.getOccupiedSpace() - passengerSpace;
    }

    @Override
    public int getUpgradeSpaceReduction() {
        switch (this.shipUpgradeLevel) {
            case NONE: {
                return 0;
            }
            case LEVEL1: {
                return this.reductionLevel1;
            }
            case LEVEL2: {
                return this.reductionLevel2;
            }
        }
        return 0;
    }

    private LateIntegerBinding createLoadBinding() {
        return new LateIntegerBinding(){

            protected int computeValue() {
                return Ship.this.internalLoadCalculation();
            }
        };
    }

    @Override
    public BooleanBinding passengerPresentProperty() {
        return this.passengerPresent;
    }

    @Override
    public int getDamage() {
        return 100 - this.fitness;
    }

    @Override
    public void damage(int damage) {
        this.fitness = Math.max(0, this.fitness - damage);
    }

    @Override
    public int getLoadableSpace() {
        return this.getSize() - this.getUpgradeSpaceReduction();
    }

    @Override
    public double getTopSpeed() {
        return this.topSpeed;
    }

    @Override
    public EShipUpgrade getShipUpgradeLevel() {
        return this.shipUpgradeLevel;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public IShipWeaponsLocation getShipWeaponsLocation() {
        return this.shipWeaponsLocation;
    }

    @Override
    public void setShipWeaponsLocation(IShipWeaponsLocation shipWeaponsLocation) {
        this.shipWeaponsLocation = shipWeaponsLocation;
    }

    @Override
    public int getMinNumberOfSailors() {
        return this.minNumberOfSailors;
    }

    @Override
    public Optional<ICaptain> getCaptian() {
        return this.captian;
    }

    @Override
    public Optional<IPerson> getPassenger() {
        return this.passenger;
    }

    @Override
    public void setLocation(Point2D location) {
        this.location = location;
    }

    @Override
    public Point2D getLocation() {
        return this.location;
    }

    @Override
    public void setOwner(IShipOwner owner) {
        this.owner = owner;
    }

    @Override
    public boolean isPiratingShip() {
        return this.piratingShip;
    }

    @Override
    public boolean isAvailable() {
        return this.available;
    }

    @Override
    public void setAvailable(boolean available) {
        this.available = available;
    }

    @Override
    public int getOccupiedSpace() {
        return this.occupiedSpace;
    }

    @Override
    public void setOccupiedSpace(int occupiedSpace) {
        this.occupiedSpace = occupiedSpace;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public String getUuid() {
        return this.uuid;
    }
}

