/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.time;

import ch.sahits.game.event.data.ClockTick;
import ch.sahits.game.event.data.ClockTickIntervalChange;
import ch.sahits.game.event.data.PeriodicalTimeDayUpdate;
import ch.sahits.game.event.data.PeriodicalTimeMonthEndUpdate;
import ch.sahits.game.event.data.PeriodicalTimeMonthUpdate;
import ch.sahits.game.event.data.PeriodicalTimeWeekEndUpdate;
import ch.sahits.game.event.data.PeriodicalTimeWeekUpdate;
import ch.sahits.game.event.data.PeriodicalTimeYearEndUpdate;
import ch.sahits.game.event.data.PeriodicalTimeYearUpdate;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.time.EUpdateIntervalRegistration;
import com.google.common.base.Preconditions;
import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.Subscribe;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public class PeriodicalTimeUpdaterV2 {
    private final Logger logger = LogManager.getLogger(this.getClass());
    private int tickInterval;
    @Autowired
    private Date date;
    private int updateInterval;
    private final EUpdateIntervalRegistration intervall;
    private int timePassed = 0;
    @Autowired
    @Qualifier(value="serverClientEventBus")
    private AsyncEventBus clientServerEventBus;
    @Autowired
    @Qualifier(value="timerEventBus")
    private AsyncEventBus timerEventBus;

    public PeriodicalTimeUpdaterV2(EUpdateIntervalRegistration intervall) {
        Preconditions.checkArgument((intervall != EUpdateIntervalRegistration.DAILY ? 1 : 0) != 0, (Object)"This updater does not handle daily events");
        this.intervall = intervall;
    }

    @PostConstruct
    public void initializeEventBus() {
        this.tickInterval = this.date.getTickUpdate();
        DateTime cal = this.date.getCurrentDate();
        switch (this.intervall) {
            case YEAR: {
                this.updateInterval = 525600;
                this.timePassed = (cal.getYear() - 1) * 24 * 60;
                this.timePassed += cal.getHourOfDay() * 60;
                this.timePassed += cal.getMinuteOfDay();
                break;
            }
            case MONTH: {
                this.updateInterval = 43200;
                this.timePassed = (cal.getDayOfMonth() - 1) * 24 * 60;
                this.timePassed += cal.getHourOfDay() * 60;
                this.timePassed += cal.getMinuteOfDay();
                break;
            }
            case WEEK: {
                this.updateInterval = 10080;
                this.timePassed = cal.getDayOfWeek() * 24 * 60;
                this.timePassed += cal.getHourOfDay() * 60;
                this.timePassed += cal.getMinuteOfDay();
                break;
            }
            case END_OF_DAY: {
                this.updateInterval = 1440;
                this.timePassed += cal.getHourOfDay() * 60;
                this.timePassed += cal.getMinuteOfDay();
                break;
            }
            case END_OF_MONTH: {
                this.updateInterval = 1440 * cal.dayOfMonth().getMaximumValue();
                this.timePassed = (cal.getDayOfMonth() - 1) * 24 * 60;
                this.timePassed += cal.getHourOfDay() * 60;
                this.timePassed += cal.getMinuteOfDay();
                break;
            }
            case END_OF_YEAR: {
                this.updateInterval = 1440 * cal.dayOfYear().getMaximumValue();
                this.timePassed = (cal.getDayOfYear() - 1) * 24 * 60;
                this.timePassed += cal.getHourOfDay() * 60;
                this.timePassed += cal.getMinuteOfDay();
                break;
            }
            case END_OF_WEEK: {
                this.updateInterval = 1440 * cal.dayOfWeek().getMaximumValue();
                this.timePassed = (cal.getDayOfWeek() - 1) * 24 * 60;
                this.timePassed += cal.getHourOfDay() * 60;
                this.timePassed += cal.getMinuteOfDay();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown update interval: " + (Object)((Object)this.intervall));
            }
        }
        this.clientServerEventBus.register((Object)this);
        this.timerEventBus.register((Object)this);
    }

    @Subscribe
    public void updateTick(ClockTickIntervalChange event) {
        this.tickInterval = event.getInterval();
    }

    @Subscribe
    public void handleClockTick(ClockTick event) {
        this.timePassed += this.tickInterval;
        if (this.timePassed > this.updateInterval) {
            switch (this.intervall) {
                case YEAR: {
                    this.clientServerEventBus.post((Object)new PeriodicalTimeYearUpdate());
                    break;
                }
                case MONTH: {
                    this.clientServerEventBus.post((Object)new PeriodicalTimeMonthUpdate());
                    break;
                }
                case WEEK: {
                    this.clientServerEventBus.post((Object)new PeriodicalTimeWeekUpdate());
                    break;
                }
                case END_OF_DAY: {
                    DateTime last;
                    this.clientServerEventBus.post((Object)new PeriodicalTimeDayUpdate());
                    int dayOfWeek = this.date.getCurrentDate().getDayOfWeek();
                    if (dayOfWeek == 7) {
                        this.clientServerEventBus.post((Object)new PeriodicalTimeWeekEndUpdate());
                    }
                    int monthOfYear = this.date.getCurrentDate().getMonthOfYear();
                    int dayOfMonth = this.date.getCurrentDate().getDayOfMonth();
                    if (monthOfYear == 12 && dayOfMonth == 31) {
                        this.clientServerEventBus.post((Object)new PeriodicalTimeYearEndUpdate());
                    }
                    if (dayOfMonth != (last = this.date.getCurrentDate().dayOfMonth().withMaximumValue()).getDayOfMonth()) break;
                    this.clientServerEventBus.post((Object)new PeriodicalTimeMonthEndUpdate());
                    break;
                }
                case END_OF_MONTH: 
                case END_OF_YEAR: 
                case END_OF_WEEK: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown update interval: " + (Object)((Object)this.intervall));
                }
            }
            this.timePassed = 0;
        }
    }

    @PreDestroy
    public void unregisterFromEventBus() {
        this.clientServerEventBus.unregister((Object)this);
        this.timerEventBus.unregister((Object)this);
    }
}

