/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.weapon;

import ch.sahits.game.openpatrician.model.product.ComputablePrice;
import ch.sahits.game.openpatrician.model.weapon.IWeapon;
import ch.sahits.game.openpatrician.util.PropertyLoader;
import com.google.common.base.Preconditions;
import java.util.Properties;
import javafx.beans.binding.IntegerBinding;
import javafx.beans.property.IntegerProperty;

public enum EWeapon implements IWeapon
{
    SWORD("sword.properties"),
    BOW("bow.properties"),
    CROSSBOW("crossbow.properties"),
    MUSKET("musket.properties"),
    BALLISTA_SMALL("ballista_small.properties"),
    TREBUCHET_SMALL("trebuchet_small.properties"),
    BALLISTA_BIG("ballista_big.properties"),
    TREBUCHET_BIG("trebuchet_big.properties"),
    BOMBARD("bombard.properties"),
    CANNON("cannon.properties"),
    HAND_WEAPON("hand_weapon.properties");

    private final int maxValueBuy;
    private final int minValueBuy;
    private final int maxValueSell;
    private final int minValueSell;
    private final int saturation;
    private ComputablePrice computablePrice;

    private EWeapon(String configFileName) {
        Properties props = PropertyLoader.loadProperties((String)configFileName);
        Preconditions.checkNotNull((Object)props.getProperty("maxValueBuy"), (Object)("The property file " + configFileName + " does not contain the maxValueBuy property"));
        Preconditions.checkNotNull((Object)props.getProperty("minValueBuy"), (Object)("The property file " + configFileName + " does not contain the minValueBuy property"));
        Preconditions.checkNotNull((Object)props.getProperty("maxValueSell"), (Object)("The property file " + configFileName + " does not contain the maxValueSell property"));
        Preconditions.checkNotNull((Object)props.getProperty("minValueSell"), (Object)("The property file " + configFileName + " does not contain the minValueSell property"));
        Preconditions.checkNotNull((Object)props.getProperty("saturation"), (Object)("The property file " + configFileName + " does not contain the saturation property"));
        this.maxValueBuy = Integer.parseInt(props.getProperty("maxValueBuy"));
        this.minValueBuy = Integer.parseInt(props.getProperty("minValueBuy"));
        this.saturation = Integer.parseInt(props.getProperty("saturation"));
        this.minValueSell = Integer.parseInt(props.getProperty("minValueSell"));
        this.maxValueSell = Integer.parseInt(props.getProperty("maxValueSell"));
        this.computablePrice = new ComputablePrice(this.maxValueBuy, this.minValueBuy, this.maxValueSell, this.minValueSell, this.saturation, this.name());
    }

    @Override
    public int buyPrice(IntegerProperty availableAmount, IntegerBinding amountToBuy) {
        return this.computablePrice.buyPrice(availableAmount, amountToBuy);
    }

    @Override
    public int sellPrice(IntegerProperty availableAmount, IntegerBinding amountToSell) {
        return this.computablePrice.sellPrice(availableAmount, amountToSell);
    }
}

