/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.server;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.ListType;
import ch.sahits.game.openpatrician.annotation.MapType;
import ch.sahits.game.openpatrician.model.MapSegmentedImage;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.server.MapSegmentDataCheck;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@ClassCategory(value={EClassCategory.SINGLETON_BEAN, EClassCategory.SERIALIZABLE_BEAN})
@Component
@Lazy
public class MapLocationDetectionModel {
    @ListType(value=MapSegmentedImage.class)
    private List<MapSegmentedImage> mapSegments = new ArrayList<MapSegmentedImage>();
    @MapType(key=INavigableVessel.class, value=MapSegmentDataCheck.class)
    private Map<INavigableVessel, MapSegmentDataCheck> checkList = new HashMap<INavigableVessel, MapSegmentDataCheck>();

    public void addSegment(MapSegmentedImage map) {
        this.mapSegments.add(map);
    }

    public void removeSegment(MapSegmentedImage map) {
        this.mapSegments.remove(map);
    }

    public boolean containsSegment(MapSegmentedImage map) {
        return this.mapSegments.contains(map);
    }

    public boolean isInCheckedList(INavigableVessel ship) {
        return this.checkList.containsKey(ship);
    }

    public List<MapSegmentedImage> getMapSegments() {
        return this.mapSegments;
    }

    public Map<INavigableVessel, MapSegmentDataCheck> getCheckList() {
        return this.checkList;
    }
}

