package ch.sahits.game.openpatrician.model;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleIntegerProperty;

/**
 * This base class for amountable items provides a count of the items.
 * @author Andi Hotz, (c) Sahits GmbH, 2011
 * Created on Dec 23, 2011
 *
 * @param <T>
 */
@ClassCategory({EClassCategory.MODEL, EClassCategory.DEPENDS_ON_SERIALIZED_BEAN})
public class BaseAmountable<T extends IAmountable> {
	/** Number of items that are amounted */
	protected final IntegerProperty amount = new SimpleIntegerProperty(this, "amount", 0);
	/**
	 * Retrieve the number of items
	 * @return
	 */
	public int getAmount(){
		return amount.get();
	}
	/**
	 * Add a number items
	 * @param amount number of the items to be added
	 */
	public void add(int amount){
		if (amount<0){
			amount = Math.abs(amount);
		}
		this.amount.set(this.getAmount() + amount);
	}
	/**
	 * Remove a number of items
	 * @param amount of items to be removed
	 */
	public void remove (int amount){
		if (amount<0){
			amount = Math.abs(amount);
		}
		if (amount==Integer.MIN_VALUE){
			amount = Integer.MAX_VALUE;
		}
		if (this.amount.get() < amount){
			this.amount.set(0);
		} else {
			this.amount.set(this.getAmount() - amount);
		}
	}
	/**
	 * Set the amount to 0.
	 */
	public void reset() {
		this.amount.set(0);
	}
	public String toString(){
		return String.valueOf(amount.get());
	}
	public IntegerProperty amountProperty() {
		return amount;
	}
}
