package ch.sahits.game.openpatrician.model.building;
/**
 * Interface defining the steward
 * @author Andi Hotz, (c) Sahits GmbH, 2012
 * Created on Jul 20, 2012
 *
 */
public interface ISteward {
	/**
	 * Retrieve the level of expertise of the steward
	 * @return
	 */
	public int getExpertiseLevel();
	/**
	 * Retrieve the weekly salary of the steward
	 * @return
	 */
	public int getSalary();

	/**
	 * Retrieve the amount of profit the steward made
	 * while on the current experiance level. The profit
	 * defines when the next level is reached. The initial
	 * amount to be reached is 10000. For each level it is 10000 more.
	 * @return
	 */
	int getTotalProfitOnExperianceLevel();

	/**
	 * Add the profit the total profit.
	 * @param profit
	 */
	void updateProfit(int profit);

	/**
	 * Retrieve the factor the steward gets when buying ware.
	 * The initial value is 0.95 and is reduced by 0.05 per experiance
	 * level.
	 * @return
	 */
	double getDiscountFactor();
}
