package ch.sahits.game.openpatrician.model.building;
/**
 * Basic interface defining the town houses
 * @author Andi Hotz, (c) Sahits GmbH, 2012
 * Created on Jul 20, 2012
 *
 */
public interface ITownHouse extends IBuilding {
	/**
	 * retrieve the capacity of the house
	 * @return
	 */
	public int getCapacity();
	/**
	 * Retrieve the occupancy of the house
	 */
	public int getOccupancy();
	/**
	 * Compute the rental income for one day
	 * @return
	 */
	public int computeRentalIncome();
	/**
	 * Retrieve the rent a tenant has to pay per month
	 */
	public void getRentPerTenant();
}
