package ch.sahits.game.openpatrician.model.building;

import ch.sahits.game.openpatrician.model.weapon.IWeapon;

/**
 * Define the stored amount of weapons
 * @author Andi Hotz, (c) Sahits GmbH, 2012
 * Created on Jul 25, 2012
 *
 */
public interface IWeaponStorage {
	/**
	 * Retrieve the amount of weapons in storage
	 * @param weapon
	 * @return
	 */
	public int getWeapon(IWeapon weapon);
	/**
	 * Move weapons in or out of storage
	 * @param weapon type of weapon
	 * @param amount to be moved (positive means into the storage, negative out of the storage)
	 * @return amount that is moved
	 */
	public int update(IWeapon weapon, int amount);
	/**
	 * check if there are any weapons stored
	 * @return
	 */
	public boolean hasWeapons();
}
