package ch.sahits.game.openpatrician.model.city;

import ch.sahits.game.openpatrician.model.city.impl.IDebt;
import ch.sahits.game.openpatrician.model.city.impl.ILoanProposal;

import java.util.List;

/**
 * Representing the loaner in a city. The loaner gets weekly updates
 * with new loan requests from citizens. He also holds the list of all
 * depts.
 * @author Andi Hotz, (c) Sahits GmbH, 2014
 *         Created on Dec 30, 2014
 */
public interface ILoaner {
    /**
     * Retrieve the list of all debts for this city.
     * @return
     */
    List<IDebt> getDebts();

    /**
     * Retrieve the loans that can be taken.
     * @return
     */
    List<ILoanProposal> getLoanProposals();

    /**
     * Regularely update the state of the loaner to present citizens that
     * require money.
     */
    void update();

    /**
     * Add a new debt to the list.
     * @param debt
     */
    void addDebt(IDebt debt);

    /**
     * List of requested loans.
     * @return
     */
    List<ILoanRequest> getRequests();

    /**
     * Retrieve the city the loaner belongs to.
     * @return
     */
    ICity getCity();
}
