package ch.sahits.game.openpatrician.model.people;

import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.MapSegmentedImage;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.datastructure.GenericPair;
import java.util.Optional;

/**
 * Provide the information the informant is willing to sell.
 * The bits of information are optional, but one bit is always present.
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 * Created on Jan 24, 2013
 *
 */
public interface IInformant extends ITavernPerson {
	/**
	 * Get the price of the information.
	 * @param player requesting the price
	 * @return
	 */
	int getPrice(IPlayer player);
	/**
	 * Retreive the name of the informant
	 * @return
	 */
	String getName();
	/**
	 * Possible information about in which city which ware is needed.
	 * @return
	 */
	Optional<GenericPair<ICity, IWare>> getWareNeeded();
	/**
	 * Possible information about in which city which ware is available in surplus.
	 * @return
	 */
	Optional<GenericPair<ICity, IWare>> getWareSurplus();
	/**
	 * Possible information about the location of a pirate.
	 * @return
	 */
	Optional<GenericPair<String, ICity>> getPirateLocation();

	/**
	 * Set the information about the needed ware in the city.
	 * @param city
	 * @param ware
	 */
	void setNeededWare(ICity city, IWare ware);

	/**
	 * Set the information about the surplus ware in the city
	 * @param city
	 * @param ware
	 */
	void setWareSurplus(ICity city, IWare ware);

	/**
	 * Set the location of the pirate.
	 * @param pirate
	 * @param city
	 */
	void setPirateLocation(ISeaPirate pirate, ICity city);
	/**
	 * The informant may also hold a map part for the player.
	 * @param player requesting player
	 * @return
	 */
	Optional<MapSegmentedImage> getMapSectionPart(IPlayer player);

	boolean isShowMapIfAvailable();

	void setShowMapIfAvailable(boolean showMapIfAvailable);

	void setPrice(int price);

	void setName(String name);
}
