package ch.sahits.game.openpatrician.model.people;

import javafx.beans.property.BooleanProperty;
import org.joda.time.DateTime;

import ch.sahits.game.openpatrician.model.city.ICity;

/**
 * Interface describing a person in the tavern, who is only part time present
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 * Created on Jan 20, 2013
 *
 */
public interface ITavernPerson extends IPerson {

	/**
	 * Person leaves the tavern.
	 */
	void leave();

	/**
	 * Person arrives in the tavern.
	 */
	void arrive();
	/**
	 * Compute the days of absence since the last arrival,
	 * if the person is not present.
	 * @return
	 */
	int getNumberOfDaysSinceArrival();

	boolean isPresent();

    /**
     * Property defining the presence/absence state.
     * @return
     */
    BooleanProperty isPresentProperty();

	int getMaxDaysAbsent();

	int getMaxDaysPresent();

	DateTime getArrivalDate();
	/**
	 * Set the city of the tavern in which the person is located.
	 * @param city
	 */
	void setCity(ICity city);

}
