package ch.sahits.game.openpatrician.model.people;

import ch.sahits.game.openpatrician.model.product.ETransferAmount;
import ch.sahits.game.openpatrician.model.weapon.EWeapon;
import ch.sahits.game.openpatrician.model.weapon.IWeapon;
import javafx.beans.binding.IntegerBinding;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;


/**
 * Defines the person in the tavern dealing in weapons.
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 * Created on Jan 25, 2013
 *
 */
public interface IWeaponsDealer extends IPerson {
    /**
     * Property representing the amount that can be bought from the dealer.
     * @param weapon that is to be sold
     * @return  integer binding representing the amount of the weapon that can be bought.
     */
    IntegerProperty amountAvailableProperty(EWeapon weapon);

    /**
     * Binding indicating the buy price.
     * @param weapon that is to be sold
     * @param amount the amount of the weapon that is wished to be bought
     * @return integer binding indicating the buy price.
     */
    IntegerBinding buyPriceBinding(ObjectProperty<ETransferAmount> amount, EWeapon weapon);

    /**
     * Binding indicating the sell price.
     * @param weapon that is to be sold
     * @param amountToSell the amount of the weapon that should be sold. This is
     *                     the amount the player has in store.
     * @return integer binding representing the price
     */
    IntegerBinding sellPriceBinding(EWeapon weapon, IntegerBinding amountToSell);
	/**
	 * Move ware into this holding. The player may be null and is not used in this
	 * base implementation, but subclasses may be interested for statistical reasons.
	 * This method is thread save.
	 * @param weapon to be moved
	 * @param amount of the ware that is moved
	 * @return the effective amount that was moved. The amount may be positive if something was added, negative if
	 * the ware was removed from the holding or zero if nothing was moved.
	 */
	int move(IWeapon weapon, int amount);
}
