package ch.sahits.game.openpatrician.model.people;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.CityProduction;
import ch.sahits.game.openpatrician.model.city.EPopulationClass;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.city.PopulationConsume;
import ch.sahits.game.openpatrician.model.product.EWare;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

/**
 * Calculator for a players reputation
 * @author Andi Hotz, (c) Sahits GmbH, 2012
 * Created on Jul 23, 2012
 *
 */
@Lazy
@Component
@ClassCategory(EClassCategory.SINGLETON_BEAN)
public class ReputationCalculator {
	@Autowired
	private PopulationConsume consumer;
	@Autowired
	private CityProduction producer;
	/**
	 * Check each ware if the player contributes and what amount.
	 * If the city contributes enough to cover the needs, this ware is
	 * irrelevant for the computation
	 * If the player contributes enough to cover all the need he gets
	 * 100 points for the ware. If he contributes less he gets a fraction
	 * according to what he contributes.
	 * @param city for which the ware based reputation should be checked
	 * @param player for whom the reputation is calculated
	 * @return value between 0 and 100
	 */
	public int calculateWareRepputation(ICity city, IPlayer player){
		double reputation = 0;
		EWare[] wares = EWare.values();
		for (EWare ware : wares){
			double need = consumer.getNeed(ware, EPopulationClass.POOR, city.getPopulation(EPopulationClass.POOR));
			need += consumer.getNeed(ware, EPopulationClass.MEDIUM, city.getPopulation(EPopulationClass.MEDIUM));
			need += consumer.getNeed(ware, EPopulationClass.RICH, city.getPopulation(EPopulationClass.RICH));
			int cityProduction = producer.getEfficientProduction(ware)+producer.getInefficientProduction(ware);
			if (need>cityProduction){
				int contribution = city.getContribution(player, ware);
				// TODO with a certain difficulty negative values might result in a penalty in the reputation
				if (contribution>0){
					if (contribution>need){
						reputation += 100;
					} else {
						reputation += contribution/need;
					}
				}
			} // end city cannot produce enough
		} // end for
		return (int) Math.rint(reputation/wares.length);
	}

}
