package ch.sahits.game.openpatrician.model.people.impl;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.model.AUpdatable;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.people.IBuyer;
import ch.sahits.game.openpatrician.model.product.AmountablePrice;
import ch.sahits.game.openpatrician.model.product.IWare;
import lombok.Getter;
import lombok.Setter;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
/**
 * Implementation of a buyer. Every city can have a buyer and is referenced
 * through it's TavernEngine.
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 * Created on Jan 20, 2013
 *
 */
@Prototype
@ClassCategory({EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
@AUpdatable
public class BuyerState extends BaseTavernPerson implements IBuyer {
	@Autowired
	private Date date;
	@Getter
	@Setter
	private String name;
	@Setter
	private DateTime deadline;
	@Getter
	@Setter
	private IWare ware;
	@Setter
	@Getter
	private AmountablePrice<IWare> amountablePrice;

	@Override
	public DateTime getTimeFrame() {
		return deadline;
	}
}

