package ch.sahits.game.openpatrician.model.people.impl;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import lombok.Getter;
import lombok.RequiredArgsConstructor;
import org.joda.time.DateTime;
import org.joda.time.Duration;

import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.people.ICaptain;
/**
 * Utility class to track which captain got when in which town
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 * Created on Jan 19, 2013
 *
 */
@RequiredArgsConstructor
@ClassCategory(EClassCategory.DEPENDS_ON_SERIALIZED_BEAN)
public class CaptainTownMapping {
    @Getter
	private final ICity town;
    @Getter
	private final DateTime arrivalDate;
    @Getter
	private final ICaptain captain;

	public int getNumbersOfDaysInTown(Date currentDate) {
		DateTime now = currentDate.getCurrentDate();
		Duration duration = new Duration(arrivalDate, now);
		return duration.toStandardDays().getDays();
	}
}
