package ch.sahits.game.openpatrician.model.people.impl;


import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.model.people.ISeaPirate;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import javafx.geometry.Point2D;
import lombok.Getter;
import lombok.Setter;

/**
 * Implementation of the sea pirate
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 * Created on Jan 29, 2013
 *
 */
@ClassCategory({EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
public class SeaPirate implements ISeaPirate {
    @Getter
    @Setter
	private String name;
	@Getter
	@Setter
	private String lastName;
    @Getter
	private Point2D location;
    @Getter
    @Setter
	private INavigableVessel ship;
    @Getter
	private int numberOfKills;
	@Getter
	@Setter
	private boolean wholeHanse;

	public void moveTo(Point2D location) {
		this.location = location;
	}


	public void incNumberOfKills() {
        numberOfKills++;
	}

}
