package ch.sahits.game.openpatrician.model.personal;
/**
 * Social rank of a player
 * @author Andi Hotz, (c) Sahits GmbH, 2012
 * Created on Jul 23, 2012
 *
 */
public enum ESocialRank {
	CHANDLER(0,0),
	BARGAINER(100000,3),
	MERCHANT(200000,6),
	TRADESMAN(300000,8),
	COUNCILMAN(500000,13),
	PATRICIAN(900000,50),
	MAYOR(0,0),
	ALDERMAN(0,0);
	
	private final int companyValue;
	private final int socialRank;
	private ESocialRank(int value,int rank){
		this.companyValue=value;
		this.socialRank=rank;
	}
	/**
	 * Retrieve the company value needed for this social rank
	 * @return
	 */
	public int getCompanyValue() {
		return companyValue;
	}
	/**
	 * Retrieve the percentage of social reputation needed for this rank
	 * @return
	 */
	public int getSocialReputation() {
		return socialRank;
	}
	
	public ESocialRank getNextRank(){
		switch (this) {
		case BARGAINER:
			return MERCHANT;
		case CHANDLER:
			return BARGAINER;
		case COUNCILMAN:
			return PATRICIAN;
		case MAYOR:
			return ALDERMAN;
		case MERCHANT:
			return TRADESMAN;
		case PATRICIAN:
			return MAYOR;
		case TRADESMAN:
			return COUNCILMAN;
		default:
			return null;
		}
	}
	
	
}
