package ch.sahits.game.openpatrician.model.personal.impl;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.personal.IPersonalData;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.RequiredArgsConstructor;
import org.joda.time.DateTime;
import org.joda.time.Years;
@RequiredArgsConstructor
@Getter
@EqualsAndHashCode
@ClassCategory(EClassCategory.DEPENDS_ON_SERIALIZED_BEAN)
public class PersonalData implements IPersonalData {

	private final String name;
	private final String lastName;
	private final boolean male;
	private final ICity birthPlace;
	private final DateTime birthDate;


	@Override
	public int getAge(DateTime now) {
		return Years.yearsBetween(birthDate, now).getYears();
	}

}
