package ch.sahits.game.openpatrician.model.ship.impl;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.model.ship.EShipType;
import ch.sahits.game.openpatrician.model.ship.EShipUpgrade;
import ch.sahits.game.openpatrician.model.ship.IHolk;

import java.util.Properties;

@Prototype
@ClassCategory({EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
public class Holk extends Ship implements IHolk {
	/**
	 * Constructor initializing the name and the upgrade level
	 * @param upgradeLevel
	 * @param name ships name
	 * @param shipConfiguration configuration properties
	 */
	public Holk(EShipUpgrade upgradeLevel, String name, Properties shipConfiguration, long timestamp) {
		super(shipConfiguration);
		this.shipUpgradeLevel = upgradeLevel;
		this.name = name;
		ShipWeaponsLocationFactory factory = new ShipWeaponsLocationFactory();
		setShipWeaponsLocation(factory.getShipWeaponsLocation(EShipType.HOLK, upgradeLevel));
	}
	/**
	 * Constructor for a Crayer without any upgrade
	 * @param name ships name
	 * @param shipConfiguration configuration properties
	 */
	public Holk(String name, Properties shipConfiguration, long timestamp) {
		this(EShipUpgrade.NONE,name, shipConfiguration, timestamp);
	}
//	@Override
//	public int getDamage() {
//		// TODO Auto-generated method stub
//		return 0;
//	}
//	@Override
//	public void damage(Object damage) {
//		// TODO Auto-generated method stub
//
//	}
	@Override
	public void repair() {
		// TODO Auto-generated method stub

	}

	@Override
	public EShipType getShipType() {
		return EShipType.HOLK;
	}


}
