package ch.sahits.game.openpatrician.model.ship.impl;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.DependentInitialisation;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.util.StartNewGameBean;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

import ch.sahits.game.openpatrician.model.ship.EShipType;
import ch.sahits.game.openpatrician.model.ship.EShipUpgrade;
import ch.sahits.game.openpatrician.model.ship.IShipWeaponsLocation;

/**
 * Ship weapons location factory
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 * Created on Jun 1, 2013
 *
 */
@Component
@Lazy
@DependentInitialisation(StartNewGameBean.class)
@ClassCategory(EClassCategory.SINGLETON_BEAN)
public class ShipWeaponsLocationFactory {

	public IShipWeaponsLocation getShipWeaponsLocation(EShipType type, EShipUpgrade level) {
		switch (type) {
		case SNAIKKA:
			switch (level) {
			case NONE:
				return new ShipWeaponsLocationSnaikkaLevel0();
			case LEVEL1:
				return new ShipWeaponsLocationSnaikkaLevel1();
			case LEVEL2:
				return new ShipWeaponsLocationSnaikkaLevel2();
			}
		case CRAYER:
			switch (level) {
			case NONE:
				return new ShipWeaponsLocationCrayerLevel0();
			case LEVEL1:
				return new ShipWeaponsLocationCrayerLevel1();
			case LEVEL2:
				return new ShipWeaponsLocationCrayerLevel2();
			}
		case COG:
			switch (level) {
			case NONE:
				return new ShipWeaponsLocationCogLevel0();
			case LEVEL1:
				return new ShipWeaponsLocationCogLevel1();
			case LEVEL2:
				return new ShipWeaponsLocationCogLevel2();
			}
		case HOLK:
			switch (level) {
			case NONE:
				return new ShipWeaponsLocationHolkLevel0();
			case LEVEL1:
				return new ShipWeaponsLocationHolkLevel1();
			case LEVEL2:
				return new ShipWeaponsLocationHolkLevel2();
			}
		}
		throw new IllegalArgumentException("Unmatched parameters: "+type+" or "+level);
	}
}
