package ch.sahits.game.openpatrician.model.util;

import ch.sahits.game.openpatrician.data.map.PirateHideout;
import ch.sahits.game.openpatrician.data.map.PirateNest;
import ch.sahits.game.openpatrician.data.map.SunkenTreasure;

import java.io.IOException;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2015
 *         Created on Dec 15, 2015
 */
public interface IMapSegmentImageCreator {
    /**
     * Create an image from the data of a pirate nest.
     * @param priateNest
     * @param mapImage
     * @throws IOException
     */
    void createMapSegment(PirateNest priateNest, String mapImage)  throws IOException ;
    /**
     * Create an image from the data of a treasure map.
     * @param treasure
     * @param mapImage
     * @throws IOException
     */
    void createMapSegment(SunkenTreasure treasure, String mapImage)  throws IOException;
    /**
     * Create an image from the data of a pirate hideout map.
     * @param hideout
     * @param mapImage
     * @throws IOException
     */
    void createMapSegment(PirateHideout hideout, String mapImage)  throws IOException;
    /**
     * Retrieve the map image and store it in the image loader under the key map
     * @param fileName
     */
    void loadMap(String fileName);
}
