package ch.sahits.game.openpatrician.model.util;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.DependentInitialisation;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.model.personal.EEconomicCareer;
import ch.sahits.game.openpatrician.model.personal.EMilitantCareer;
import ch.sahits.game.openpatrician.model.personal.ESocialRank;
import ch.sahits.game.openpatrician.model.personal.ICareer;
import ch.sahits.game.openpatrician.model.product.EWare;
import ch.sahits.game.openpatrician.model.ship.EShipType;
import ch.sahits.game.openpatrician.model.weapon.EWeapon;
import ch.sahits.game.openpatrician.util.StartNewGameBean;
import ch.sahits.game.openpatrician.util.l10n.Locale;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

/**
 * Service that provides the proper translations for enumeration balues and constants.
 * @author Andi Hotz, (c) Sahits GmbH, 2014
 *         Created on Nov 26, 2014
 */
@Service
@Lazy
@DependentInitialisation(StartNewGameBean.class)
@ClassCategory(EClassCategory.SINGLETON_BEAN)
public class ModelTranslations {
    @Autowired
    private Locale locale;
    @Autowired
    @Qualifier("messageSource")
    private MessageSource messages;

    /**
     * Retrieve the localized display name for <code>id</code>.
     * @param weapon ennumeration
     * @return
     */
    public String getLocalDisplayName(EWeapon weapon) {
        return messages.getMessage(weapon.name(), new Object[0], locale.getCurrentLocal());
    }
    /**
     * Retrieve the localized display name for <code>id</code>.
     * @param ware
     * @return
     */
    public String getLocalDisplayName(EWare ware){
        return messages.getMessage(ware.getWareID(), new Object[0], locale.getCurrentLocal());
    }

    public String getLocalDisplayName(ICareer career) {
        if (career instanceof EEconomicCareer) {
            return messages.getMessage(((EEconomicCareer)career).name(), new Object[0], locale.getCurrentLocal());
        } else if (career instanceof EMilitantCareer) {
            return messages.getMessage(((EMilitantCareer)career).name(), new Object[0], locale.getCurrentLocal());
        } else {
            throw new IllegalArgumentException("Unknown career implementation: "+career.getClass().getName());
        }
    }

    public String getLocalDisplayName(ESocialRank rank) {
        return messages.getMessage(rank.name(), new Object[0], locale.getCurrentLocal());
    }
    public String getLocalDisplayName(EShipType type) {
        return messages.getMessage(type.name(), new Object[0], locale.getCurrentLocal());
    }
    public String getLocalDisplayNameWithArticle(EShipType type, boolean upperCaseArticle) {
        String typeName = getLocalDisplayName(type);
        String key = "ch.sahits.game.openpatrician.model.util.ModelTranslations."+type.name().toLowerCase()+"Article";
        String article;
        if (EShipType.HOLK == type || EShipType.CRAYER == type) {
            article = getLocalDisplayDistinctArticle(true, upperCaseArticle);
        } else {
            article = getLocalDisplayDistinctArticle(false, upperCaseArticle);
        }
        return article + " " + typeName;
    }

    public String getLocalDisplayDistinctArticle(boolean male, boolean uppercase) {
        String key = "articleMale";
        if (!male) {
            key = "articleFemale";
        }
        String article = messages.getMessage(key, new Object[0], locale.getCurrentLocal());
        if (uppercase) {
            article = article.substring(0,1).toUpperCase() + article.substring(1);
        }
        return article;
    }
}
