/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model;

import ch.sahits.game.event.data.ClockTickIntervalChange;
import ch.sahits.game.openpatrician.IInvalidatable;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.ObjectPropertyType;
import ch.sahits.game.openpatrician.util.l10n.Locale;
import com.google.common.base.Preconditions;
import com.google.common.eventbus.AsyncEventBus;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import javafx.beans.binding.StringBinding;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Component;

@Component
@ClassCategory(value={EClassCategory.SERIALIZABLE_BEAN, EClassCategory.SINGLETON_BEAN})
public class Date
implements IInvalidatable {
    @XStreamOmitField
    private final Logger logger = LogManager.getLogger(this.getClass());
    public static final int DEFAULT_INVALID_START_YEAR = 0;
    private int tickUpdate;
    @ObjectPropertyType(value=DateTime.class)
    private ObjectProperty<DateTime> cal = new SimpleObjectProperty((Object)this, "cal", null);
    private DateTime startDate;
    private Integer startYear = null;
    private static Object lock = new Object();
    @XStreamOmitField
    private StringBinding dayDateBinding = null;
    @Autowired
    @Qualifier(value="serverClientEventBus")
    @XStreamOmitField
    private AsyncEventBus clientServerEventBus;
    @Autowired
    @XStreamOmitField
    private Locale locale;
    @Autowired
    @XStreamOmitField
    private MessageSource messageSource;

    public Date(int year) {
        this();
        this.setStartYear(year);
    }

    public Date() {
        this.tickUpdate = 5;
    }

    public void resetStartYear(int startYear) {
        System.out.println("+++++++++++++++++++ set start year: " + startYear);
        this.startYear = startYear;
        this.updateTime(new DateTime(startYear, 7, 13, 0, 0));
        this.startDate = this.getCurrentDate();
    }

    public void setStartYear(int startYear) {
        Preconditions.checkState((boolean)this.checkStartYear(startYear), (Object)"Date may only be initialized once");
        this.resetStartYear(startYear);
    }

    private boolean checkStartYear(int startYear) {
        if (this.startYear == null) {
            return true;
        }
        return this.startYear == 0;
    }

    Date(DateTime cal) {
        this.updateTime(cal);
        this.startYear = cal.getYear();
        this.tickUpdate = 5;
    }

    public void updateTime(DateTime newTime) {
        if (this.cal.get() != null && !this.isToday(newTime) && this.dayDateBinding != null) {
            this.dayDateBinding.invalidate();
        }
        Preconditions.checkNotNull((Object)newTime);
        this.cal.set((Object)newTime);
    }

    public void setTickUpdate(int minutes) {
        this.tickUpdate = minutes;
        ClockTickIntervalChange event = new ClockTickIntervalChange();
        event.setInterval(this.tickUpdate);
        this.clientServerEventBus.post((Object)event);
    }

    public String getStartOfWeek() {
        DateTime lastMon = this.getStartOfWeekInternal();
        return this.toShortDate(lastMon);
    }

    DateTime getStartOfWeekInternal() {
        DateTime lastMonday = ((DateTime)this.cal.get()).minusWeeks(1);
        lastMonday = lastMonday.minusDays(lastMonday.getDayOfWeek() - 1);
        return lastMonday;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toShortDate(DateTime c) {
        int month;
        int day;
        Object object = lock;
        synchronized (object) {
            day = c.getDayOfMonth();
            month = c.getMonthOfYear();
        }
        StringBuilder sb = new StringBuilder();
        sb.append(day).append(". ");
        sb.append(this.messageSource.getMessage("month_short_" + month, new Object[0], this.locale.getCurrentLocal()));
        return sb.toString();
    }

    public String getEndOfWeek() {
        DateTime lastSun = this.getEndOfWeekInternal();
        return this.toShortDate(lastSun);
    }

    DateTime getEndOfWeekInternal() {
        int cdow = ((DateTime)this.cal.get()).getDayOfWeek();
        DateTime lastDayOfWeek = ((DateTime)this.cal.get()).plusDays(7 - cdow);
        return lastDayOfWeek;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toDisplayString() {
        int year;
        int month;
        int day;
        Object object = lock;
        synchronized (object) {
            day = ((DateTime)this.cal.get()).getDayOfMonth();
            month = ((DateTime)this.cal.get()).getMonthOfYear();
            year = ((DateTime)this.cal.get()).getYear();
        }
        return this.todisplayString(day, month, year);
    }

    public StringBinding dayDateBinding() {
        if (this.dayDateBinding == null) {
            this.dayDateBinding = new StringBinding(){

                protected String computeValue() {
                    return Date.this.toDisplayString();
                }
            };
        }
        return this.dayDateBinding;
    }

    public String todisplayString(int day, int month, int year) {
        StringBuilder sb = new StringBuilder();
        sb.append(day).append(". ");
        sb.append(this.messageSource.getMessage("month_short_" + month, new Object[0], this.locale.getCurrentLocal())).append(" ");
        sb.append(year);
        return sb.toString();
    }

    public boolean isSameDay(DateTime date1, DateTime date2) {
        return date1.toDateMidnight().equals((Object)date2.toDateMidnight());
    }

    public boolean isToday(DateTime date) {
        return date.toDateMidnight().equals((Object)this.getCurrentDate().toDateMidnight());
    }

    public DateTime getCurrentDate() {
        return (DateTime)this.cal.get();
    }

    public ObjectProperty<DateTime> getCurrentDateProperty() {
        return this.cal;
    }

    public final int getWeekdayIndex() {
        int dayOfWeek = ((DateTime)this.cal.get()).getDayOfWeek() + 1;
        return (dayOfWeek - 2) % 7;
    }

    public void invalidate() {
        this.dayDateBinding.invalidate();
        this.dayDateBinding = null;
        this.dayDateBinding();
    }

    public int getTickUpdate() {
        return this.tickUpdate;
    }

    public DateTime getStartDate() {
        return this.startDate;
    }

    public Integer getStartYear() {
        return this.startYear;
    }
}

