/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.city;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.DependentInitialisation;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.MapType;
import ch.sahits.game.openpatrician.data.map.Cities;
import ch.sahits.game.openpatrician.data.map.City;
import ch.sahits.game.openpatrician.data.map.Map;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.city.cityhall.impl.FoundNewSettlement;
import ch.sahits.game.openpatrician.util.MapSegmentImageFactory;
import ch.sahits.game.openpatrician.util.StartNewGameBean;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Lazy;
import org.springframework.oxm.Unmarshaller;
import org.springframework.stereotype.Component;

@Component
@Lazy
@DependentInitialisation(value=StartNewGameBean.class)
@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public class CityFactory {
    private static final Logger logger = LogManager.getLogger(CityFactory.class);
    @Autowired
    @Qualifier(value="jaxb2MapMarshaller")
    private Unmarshaller unmarshaller;
    @Autowired
    private ApplicationContext context;
    @Autowired
    private MapSegmentImageFactory mapSegmentImageFactory;
    @MapType(key=String.class, value=ICity.class)
    private static ConcurrentHashMap<String, ICity> createdCityCache = new ConcurrentHashMap();
    private Map map;

    private List<City> getCities(String mapName) {
        try {
            this.map = (Map)this.unmarshaller.unmarshal(this.getSourceFromFile(mapName));
            this.mapSegmentImageFactory.initializeImages();
            Cities cities = this.map.getCities();
            return cities.getCity();
        }
        catch (IOException e) {
            logger.error("Could not load cities from file " + mapName, (Throwable)e);
            return Lists.newArrayList();
        }
    }

    private Source getSourceFromFile(String fileName) {
        InputStream resourceAsStream = this.getClass().getResourceAsStream(fileName);
        return new StreamSource(resourceAsStream);
    }

    public void initializeCityCache(String mapName) throws IOException {
        List<City> cities = this.getCities(mapName);
        for (City city : cities) {
            createdCityCache.put(city.getName(), this.createCity(city));
        }
    }

    private ICity createCity(City city) {
        return (ICity)this.context.getBean("cityBean", new Object[]{city});
    }

    public Collection<ICity> getCities() {
        return createdCityCache.values();
    }

    public ICity createCityByName(String cityName) throws IOException {
        return createdCityCache.get(cityName.toUpperCase());
    }

    public ICity createFutureCity(FoundNewSettlement city) {
        ICity newCity = (ICity)this.context.getBean("cityBean", new Object[]{city});
        createdCityCache.put(city.getName(), newCity);
        return newCity;
    }

    public void setUnmarshaller(Unmarshaller unmarshaller) {
        this.unmarshaller = unmarshaller;
    }

    public Map getMap() {
        return this.map;
    }
}

