/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.city;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.DependentInitialisation;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.MapType;
import ch.sahits.game.openpatrician.model.product.EWare;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.util.PropertyLoader;
import ch.sahits.game.openpatrician.util.StartNewGameBean;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
@Lazy
@DependentInitialisation(value=StartNewGameBean.class)
@ClassCategory(value={EClassCategory.SERIALIZABLE_BEAN, EClassCategory.SINGLETON_BEAN})
public class CityProduction {
    @MapType(key=IWare.class, value=Integer.class)
    private Map<IWare, Integer> productionRates = new HashMap<IWare, Integer>();

    public CityProduction() {
        EWare[] wares;
        Properties props = PropertyLoader.loadProperties((String)"productionrates.properties");
        for (EWare ware : wares = EWare.values()) {
            this.productionRates.put(ware, Integer.parseInt(props.getProperty(ware.name())));
        }
    }

    public int getEfficientProduction(IWare ware) {
        return this.productionRates.get(ware);
    }

    public int getInefficientProduction(IWare ware) {
        return this.productionRates.get(ware) / 2;
    }

    public int getProduction(IWare ware) {
        return this.getEfficientProduction(ware) + this.getInefficientProduction(ware);
    }
}

