/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.city.cityhall.impl;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.model.city.cityhall.ITreasury;
import javafx.application.Platform;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.LongProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleLongProperty;

@ClassCategory(value={EClassCategory.DEPENDS_ON_SERIALIZED_BEAN})
public class Treasury
implements ITreasury {
    private DoubleProperty currentHeadTaxValue = new SimpleDoubleProperty(4.0);
    private DoubleProperty currentPropertyTax = new SimpleDoubleProperty(280.0);
    private LongProperty paidTaxes = new SimpleLongProperty(0L);
    private LongProperty paidSpecialTaxes = new SimpleLongProperty(0L);
    private IntegerProperty cityGuardCosts = new SimpleIntegerProperty(0);
    private IntegerProperty buildingCosts = new SimpleIntegerProperty(0);
    private IntegerProperty outriggerCosts = new SimpleIntegerProperty(0);
    private IntegerProperty siegeCosts = new SimpleIntegerProperty(0);
    private IntegerProperty otherCosts = new SimpleIntegerProperty(0);
    private IntegerProperty otherIncome = new SimpleIntegerProperty(0);
    private IntegerProperty donations = new SimpleIntegerProperty(0);
    private LongProperty cash = new SimpleLongProperty(0L);

    public void reset() {
        this.paidTaxes.setValue((Number)0);
        this.paidSpecialTaxes.setValue((Number)0);
        this.cityGuardCosts.setValue((Number)0);
        this.buildingCosts.setValue((Number)0);
        this.outriggerCosts.setValue((Number)0);
        this.siegeCosts.setValue((Number)0);
        this.otherIncome.setValue((Number)0);
        this.otherCosts.setValue((Number)0);
        this.donations.setValue((Number)0);
    }

    public void setCurrentHeadTaxValue(double currentHeadTaxValue) {
        this.currentHeadTaxValue.setValue((Number)currentHeadTaxValue);
    }

    public void addPaidTaxes(long paidTaxes) {
        Platform.runLater(() -> {
            this.paidTaxes.setValue((Number)(this.paidTaxes.longValue() + paidTaxes));
            this.cash.setValue((Number)(this.cash.get() + paidTaxes));
        });
    }

    public void addPaidSpecialTaxes(long paidSpecialTaxes) {
        Platform.runLater(() -> {
            this.paidSpecialTaxes.setValue((Number)(this.paidSpecialTaxes.longValue() + paidSpecialTaxes));
            this.cash.setValue((Number)(this.cash.get() + paidSpecialTaxes));
        });
    }

    public void subtractCityGuardCosts(int cityGuardCosts) {
        Platform.runLater(() -> {
            this.cityGuardCosts.setValue((Number)(this.cityGuardCosts.intValue() - cityGuardCosts));
            this.cash.setValue((Number)(this.cash.get() - (long)cityGuardCosts));
        });
    }

    public void subtractBuildingCosts(int buildingCosts) {
        Platform.runLater(() -> {
            this.buildingCosts.setValue((Number)(this.buildingCosts.intValue() - buildingCosts));
            this.cash.setValue((Number)(this.cash.get() - (long)buildingCosts));
        });
    }

    public void subtractOutriggerCosts(int outriggerCosts) {
        Platform.runLater(() -> {
            this.outriggerCosts.setValue((Number)(this.outriggerCosts.intValue() - outriggerCosts));
            this.cash.setValue((Number)(this.cash.get() - (long)outriggerCosts));
        });
    }

    public void subtractSiegeCosts(int siegeCosts) {
        Platform.runLater(() -> {
            this.siegeCosts.setValue((Number)(this.siegeCosts.intValue() - siegeCosts));
            this.cash.setValue((Number)(this.cash.get() - (long)siegeCosts));
        });
    }

    public void subtractOtherCosts(int otherCosts) {
        Platform.runLater(() -> {
            this.otherCosts.setValue((Number)(this.otherCosts.intValue() - otherCosts));
            this.cash.setValue((Number)(this.cash.get() - (long)otherCosts));
        });
    }

    public void addOtherIncome(int otherIncome) {
        Platform.runLater(() -> {
            this.otherIncome.setValue((Number)(this.otherIncome.intValue() + otherIncome));
            this.cash.setValue((Number)(this.cash.get() + (long)otherIncome));
        });
    }

    public void addDonations(int donations) {
        Platform.runLater(() -> {
            this.donations.setValue((Number)(this.donations.intValue() + donations));
            this.cash.setValue((Number)(this.cash.get() + (long)donations));
        });
    }

    @Override
    public long getCash() {
        return this.cash.get();
    }

    @Override
    public LongProperty cashProperty() {
        return this.cash;
    }

    public void setCash(long cash) {
        this.cash.set(cash);
    }

    @Override
    public DoubleProperty currentHeadTaxValueProperty() {
        return this.currentHeadTaxValue;
    }

    @Override
    public DoubleProperty currentPropertyTaxProperty() {
        return this.currentPropertyTax;
    }

    @Override
    public LongProperty paidTaxesProperty() {
        return this.paidTaxes;
    }

    @Override
    public LongProperty paidSpecialTaxesProperty() {
        return this.paidSpecialTaxes;
    }

    @Override
    public IntegerProperty cityGuardCostsProperty() {
        return this.cityGuardCosts;
    }

    @Override
    public IntegerProperty buildingCostsProperty() {
        return this.buildingCosts;
    }

    @Override
    public IntegerProperty outriggerCostsProperty() {
        return this.outriggerCosts;
    }

    @Override
    public IntegerProperty siegeCostsProperty() {
        return this.siegeCosts;
    }

    @Override
    public IntegerProperty otherCostsProperty() {
        return this.otherCosts;
    }

    @Override
    public IntegerProperty otherIncomeProperty() {
        return this.otherIncome;
    }

    @Override
    public IntegerProperty donationsProperty() {
        return this.donations;
    }

    @Override
    public double getCurrentHeadTaxValue() {
        return this.currentHeadTaxValue.get();
    }

    @Override
    public double getCurrentPropertyTax() {
        return this.currentPropertyTax.get();
    }

    @Override
    public long getPaidTaxes() {
        return this.paidTaxes.get();
    }

    @Override
    public long getPaidSpecialTaxes() {
        return this.paidSpecialTaxes.get();
    }

    @Override
    public int getCityGuardCosts() {
        return this.cityGuardCosts.get();
    }

    @Override
    public int getBuildingCosts() {
        return this.buildingCosts.get();
    }

    @Override
    public int getOutriggerCosts() {
        return this.outriggerCosts.get();
    }

    @Override
    public int getSiegeCosts() {
        return this.siegeCosts.get();
    }

    @Override
    public int getOtherCosts() {
        return this.otherCosts.get();
    }

    @Override
    public int getOtherIncome() {
        return this.otherIncome.get();
    }

    @Override
    public int getDonations() {
        return this.donations.get();
    }
}

